package io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConversionReviewFluentImpl<A extends ConversionReviewFluent<A>> extends BaseFluent<A> implements ConversionReviewFluent<A>{
  public ConversionReviewFluentImpl() {
  }
  public ConversionReviewFluentImpl(ConversionReview instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withRequest(instance.getRequest());
      this.withResponse(instance.getResponse());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String kind;
  private ConversionRequestBuilder request;
  private ConversionResponseBuilder response;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRequest instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConversionRequest getRequest() {
    return this.request!=null ?this.request.build():null;
  }
  public ConversionRequest buildRequest() {
    return this.request!=null ?this.request.build():null;
  }
  public A withRequest(ConversionRequest request) {
    _visitables.get("request").remove(this.request);
    if (request!=null){ this.request= new ConversionRequestBuilder(request); _visitables.get("request").add(this.request);} else { this.request = null; _visitables.get("request").remove(this.request); } return (A) this;
  }
  public Boolean hasRequest() {
    return this.request != null;
  }
  public ConversionReviewFluentImpl.RequestNested<A> withNewRequest() {
    return new ConversionReviewFluentImpl.RequestNestedImpl();
  }
  public ConversionReviewFluentImpl.RequestNested<A> withNewRequestLike(ConversionRequest item) {
    return new ConversionReviewFluentImpl.RequestNestedImpl(item);
  }
  public ConversionReviewFluentImpl.RequestNested<A> editRequest() {
    return withNewRequestLike(getRequest());
  }
  public ConversionReviewFluentImpl.RequestNested<A> editOrNewRequest() {
    return withNewRequestLike(getRequest() != null ? getRequest(): new ConversionRequestBuilder().build());
  }
  public ConversionReviewFluentImpl.RequestNested<A> editOrNewRequestLike(ConversionRequest item) {
    return withNewRequestLike(getRequest() != null ? getRequest(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResponse instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConversionResponse getResponse() {
    return this.response!=null ?this.response.build():null;
  }
  public ConversionResponse buildResponse() {
    return this.response!=null ?this.response.build():null;
  }
  public A withResponse(ConversionResponse response) {
    _visitables.get("response").remove(this.response);
    if (response!=null){ this.response= new ConversionResponseBuilder(response); _visitables.get("response").add(this.response);} else { this.response = null; _visitables.get("response").remove(this.response); } return (A) this;
  }
  public Boolean hasResponse() {
    return this.response != null;
  }
  public ConversionReviewFluentImpl.ResponseNested<A> withNewResponse() {
    return new ConversionReviewFluentImpl.ResponseNestedImpl();
  }
  public ConversionReviewFluentImpl.ResponseNested<A> withNewResponseLike(ConversionResponse item) {
    return new ConversionReviewFluentImpl.ResponseNestedImpl(item);
  }
  public ConversionReviewFluentImpl.ResponseNested<A> editResponse() {
    return withNewResponseLike(getResponse());
  }
  public ConversionReviewFluentImpl.ResponseNested<A> editOrNewResponse() {
    return withNewResponseLike(getResponse() != null ? getResponse(): new ConversionResponseBuilder().build());
  }
  public ConversionReviewFluentImpl.ResponseNested<A> editOrNewResponseLike(ConversionResponse item) {
    return withNewResponseLike(getResponse() != null ? getResponse(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConversionReviewFluentImpl that = (ConversionReviewFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(request, that.request)) return false;

    if (!java.util.Objects.equals(response, that.response)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  request,  response,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (request != null) { sb.append("request:"); sb.append(request + ","); }
    if (response != null) { sb.append("response:"); sb.append(response + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RequestNestedImpl<N> extends ConversionRequestFluentImpl<ConversionReviewFluentImpl.RequestNested<N>> implements ConversionReviewFluentImpl.RequestNested<N>,Nested<N>{
    RequestNestedImpl(ConversionRequest item) {
      this.builder = new ConversionRequestBuilder(this, item);
    }
    RequestNestedImpl() {
      this.builder = new ConversionRequestBuilder(this);
    }
    ConversionRequestBuilder builder;
    public N and() {
      return (N) ConversionReviewFluentImpl.this.withRequest(builder.build());
    }
    public N endRequest() {
      return and();
    }
    
  }
  class ResponseNestedImpl<N> extends ConversionResponseFluentImpl<ConversionReviewFluentImpl.ResponseNested<N>> implements ConversionReviewFluentImpl.ResponseNested<N>,Nested<N>{
    ResponseNestedImpl(ConversionResponse item) {
      this.builder = new ConversionResponseBuilder(this, item);
    }
    ResponseNestedImpl() {
      this.builder = new ConversionResponseBuilder(this);
    }
    ConversionResponseBuilder builder;
    public N and() {
      return (N) ConversionReviewFluentImpl.this.withResponse(builder.build());
    }
    public N endResponse() {
      return and();
    }
    
  }
  
}