package io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CustomResourceConversionFluentImpl<A extends CustomResourceConversionFluent<A>> extends BaseFluent<A> implements CustomResourceConversionFluent<A>{
  public CustomResourceConversionFluentImpl() {
  }
  public CustomResourceConversionFluentImpl(CustomResourceConversion instance) {
    if (instance != null) {
      this.withStrategy(instance.getStrategy());
      this.withWebhook(instance.getWebhook());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String strategy;
  private WebhookConversionBuilder webhook;
  private Map<String,Object> additionalProperties;
  public String getStrategy() {
    return this.strategy;
  }
  public A withStrategy(String strategy) {
    this.strategy=strategy; return (A) this;
  }
  public Boolean hasStrategy() {
    return this.strategy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildWebhook instead.
   * @return The buildable object.
   */
  @Deprecated
  public WebhookConversion getWebhook() {
    return this.webhook!=null ?this.webhook.build():null;
  }
  public WebhookConversion buildWebhook() {
    return this.webhook!=null ?this.webhook.build():null;
  }
  public A withWebhook(WebhookConversion webhook) {
    _visitables.get("webhook").remove(this.webhook);
    if (webhook!=null){ this.webhook= new WebhookConversionBuilder(webhook); _visitables.get("webhook").add(this.webhook);} else { this.webhook = null; _visitables.get("webhook").remove(this.webhook); } return (A) this;
  }
  public Boolean hasWebhook() {
    return this.webhook != null;
  }
  public CustomResourceConversionFluentImpl.WebhookNested<A> withNewWebhook() {
    return new CustomResourceConversionFluentImpl.WebhookNestedImpl();
  }
  public CustomResourceConversionFluentImpl.WebhookNested<A> withNewWebhookLike(WebhookConversion item) {
    return new CustomResourceConversionFluentImpl.WebhookNestedImpl(item);
  }
  public CustomResourceConversionFluentImpl.WebhookNested<A> editWebhook() {
    return withNewWebhookLike(getWebhook());
  }
  public CustomResourceConversionFluentImpl.WebhookNested<A> editOrNewWebhook() {
    return withNewWebhookLike(getWebhook() != null ? getWebhook(): new WebhookConversionBuilder().build());
  }
  public CustomResourceConversionFluentImpl.WebhookNested<A> editOrNewWebhookLike(WebhookConversion item) {
    return withNewWebhookLike(getWebhook() != null ? getWebhook(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomResourceConversionFluentImpl that = (CustomResourceConversionFluentImpl) o;
    if (!java.util.Objects.equals(strategy, that.strategy)) return false;

    if (!java.util.Objects.equals(webhook, that.webhook)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(strategy,  webhook,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (webhook != null) { sb.append("webhook:"); sb.append(webhook + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class WebhookNestedImpl<N> extends WebhookConversionFluentImpl<CustomResourceConversionFluentImpl.WebhookNested<N>> implements CustomResourceConversionFluentImpl.WebhookNested<N>,Nested<N>{
    WebhookNestedImpl(WebhookConversion item) {
      this.builder = new WebhookConversionBuilder(this, item);
    }
    WebhookNestedImpl() {
      this.builder = new WebhookConversionBuilder(this);
    }
    WebhookConversionBuilder builder;
    public N and() {
      return (N) CustomResourceConversionFluentImpl.this.withWebhook(builder.build());
    }
    public N endWebhook() {
      return and();
    }
    
  }
  
}