package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CustomResourceDefinitionVersionFluentImpl<A extends CustomResourceDefinitionVersionFluent<A>> extends BaseFluent<A> implements CustomResourceDefinitionVersionFluent<A>{
  public CustomResourceDefinitionVersionFluentImpl() {
  }
  public CustomResourceDefinitionVersionFluentImpl(CustomResourceDefinitionVersion instance) {
    if (instance != null) {
      this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns());
      this.withDeprecated(instance.getDeprecated());
      this.withDeprecationWarning(instance.getDeprecationWarning());
      this.withName(instance.getName());
      this.withSchema(instance.getSchema());
      this.withServed(instance.getServed());
      this.withStorage(instance.getStorage());
      this.withSubresources(instance.getSubresources());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<CustomResourceColumnDefinitionBuilder> additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();
  private Boolean deprecated;
  private String deprecationWarning;
  private String name;
  private CustomResourceValidationBuilder schema;
  private Boolean served;
  private Boolean storage;
  private CustomResourceSubresourcesBuilder subresources;
  private Map<String,Object> additionalProperties;
  public A addToAdditionalPrinterColumns(int index,CustomResourceColumnDefinition item) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
    if (index < 0 || index >= additionalPrinterColumns.size()) { _visitables.get("additionalPrinterColumns").add(builder); additionalPrinterColumns.add(builder); } else { _visitables.get("additionalPrinterColumns").add(index, builder); additionalPrinterColumns.add(index, builder);}
    return (A)this;
  }
  public A setToAdditionalPrinterColumns(int index,CustomResourceColumnDefinition item) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
    if (index < 0 || index >= additionalPrinterColumns.size()) { _visitables.get("additionalPrinterColumns").add(builder); additionalPrinterColumns.add(builder); } else { _visitables.get("additionalPrinterColumns").set(index, builder); additionalPrinterColumns.set(index, builder);}
    return (A)this;
  }
  public A addToAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceColumnDefinition... items) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
  }
  public A addAllToAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
  }
  public A removeFromAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceColumnDefinition... items) {
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder);if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.remove(builder);}} return (A)this;
  }
  public A removeAllFromAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder);if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAdditionalPrinterColumns(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    if (additionalPrinterColumns == null) return (A) this;
    final Iterator<CustomResourceColumnDefinitionBuilder> each = additionalPrinterColumns.iterator();
    final List visitables = _visitables.get("additionalPrinterColumns");
    while (each.hasNext()) {
      CustomResourceColumnDefinitionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAdditionalPrinterColumns instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CustomResourceColumnDefinition> getAdditionalPrinterColumns() {
    return additionalPrinterColumns != null ? build(additionalPrinterColumns) : null;
  }
  public List<CustomResourceColumnDefinition> buildAdditionalPrinterColumns() {
    return additionalPrinterColumns != null ? build(additionalPrinterColumns) : null;
  }
  public CustomResourceColumnDefinition buildAdditionalPrinterColumn(int index) {
    return this.additionalPrinterColumns.get(index).build();
  }
  public CustomResourceColumnDefinition buildFirstAdditionalPrinterColumn() {
    return this.additionalPrinterColumns.get(0).build();
  }
  public CustomResourceColumnDefinition buildLastAdditionalPrinterColumn() {
    return this.additionalPrinterColumns.get(additionalPrinterColumns.size() - 1).build();
  }
  public CustomResourceColumnDefinition buildMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    for (CustomResourceColumnDefinitionBuilder item: additionalPrinterColumns) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    for (CustomResourceColumnDefinitionBuilder item: additionalPrinterColumns) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalPrinterColumns(List<CustomResourceColumnDefinition> additionalPrinterColumns) {
    if (this.additionalPrinterColumns != null) { _visitables.get("additionalPrinterColumns").clear();}
    if (additionalPrinterColumns != null) {this.additionalPrinterColumns = new ArrayList(); for (CustomResourceColumnDefinition item : additionalPrinterColumns){this.addToAdditionalPrinterColumns(item);}} else { this.additionalPrinterColumns = null;} return (A) this;
  }
  public A withAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceColumnDefinition... additionalPrinterColumns) {
    if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.clear(); _visitables.remove("additionalPrinterColumns"); }
    if (additionalPrinterColumns != null) {for (CustomResourceColumnDefinition item :additionalPrinterColumns){ this.addToAdditionalPrinterColumns(item);}} return (A) this;
  }
  public Boolean hasAdditionalPrinterColumns() {
    return additionalPrinterColumns != null && !additionalPrinterColumns.isEmpty();
  }
  public CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumn() {
    return new CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNestedImpl();
  }
  public CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumnLike(CustomResourceColumnDefinition item) {
    return new CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNestedImpl(-1, item);
  }
  public CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNested<A> setNewAdditionalPrinterColumnLike(int index,CustomResourceColumnDefinition item) {
    return new CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNestedImpl(index, item);
  }
  public CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNested<A> editAdditionalPrinterColumn(int index) {
    if (additionalPrinterColumns.size() <= index) throw new RuntimeException("Can't edit additionalPrinterColumns. Index exceeds size.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  public CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNested<A> editFirstAdditionalPrinterColumn() {
    if (additionalPrinterColumns.size() == 0) throw new RuntimeException("Can't edit first additionalPrinterColumns. The list is empty.");
    return setNewAdditionalPrinterColumnLike(0, buildAdditionalPrinterColumn(0));
  }
  public CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNested<A> editLastAdditionalPrinterColumn() {
    int index = additionalPrinterColumns.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalPrinterColumns. The list is empty.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  public CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNested<A> editMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalPrinterColumns.size();i++) { 
    if (predicate.test(additionalPrinterColumns.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalPrinterColumns. No match found.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  public Boolean getDeprecated() {
    return this.deprecated;
  }
  public A withDeprecated(Boolean deprecated) {
    this.deprecated=deprecated; return (A) this;
  }
  public Boolean hasDeprecated() {
    return this.deprecated != null;
  }
  public String getDeprecationWarning() {
    return this.deprecationWarning;
  }
  public A withDeprecationWarning(String deprecationWarning) {
    this.deprecationWarning=deprecationWarning; return (A) this;
  }
  public Boolean hasDeprecationWarning() {
    return this.deprecationWarning != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSchema instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomResourceValidation getSchema() {
    return this.schema!=null ?this.schema.build():null;
  }
  public CustomResourceValidation buildSchema() {
    return this.schema!=null ?this.schema.build():null;
  }
  public A withSchema(CustomResourceValidation schema) {
    _visitables.get("schema").remove(this.schema);
    if (schema!=null){ this.schema= new CustomResourceValidationBuilder(schema); _visitables.get("schema").add(this.schema);} else { this.schema = null; _visitables.get("schema").remove(this.schema); } return (A) this;
  }
  public Boolean hasSchema() {
    return this.schema != null;
  }
  public CustomResourceDefinitionVersionFluentImpl.SchemaNested<A> withNewSchema() {
    return new CustomResourceDefinitionVersionFluentImpl.SchemaNestedImpl();
  }
  public CustomResourceDefinitionVersionFluentImpl.SchemaNested<A> withNewSchemaLike(CustomResourceValidation item) {
    return new CustomResourceDefinitionVersionFluentImpl.SchemaNestedImpl(item);
  }
  public CustomResourceDefinitionVersionFluentImpl.SchemaNested<A> editSchema() {
    return withNewSchemaLike(getSchema());
  }
  public CustomResourceDefinitionVersionFluentImpl.SchemaNested<A> editOrNewSchema() {
    return withNewSchemaLike(getSchema() != null ? getSchema(): new CustomResourceValidationBuilder().build());
  }
  public CustomResourceDefinitionVersionFluentImpl.SchemaNested<A> editOrNewSchemaLike(CustomResourceValidation item) {
    return withNewSchemaLike(getSchema() != null ? getSchema(): item);
  }
  public Boolean getServed() {
    return this.served;
  }
  public A withServed(Boolean served) {
    this.served=served; return (A) this;
  }
  public Boolean hasServed() {
    return this.served != null;
  }
  public Boolean getStorage() {
    return this.storage;
  }
  public A withStorage(Boolean storage) {
    this.storage=storage; return (A) this;
  }
  public Boolean hasStorage() {
    return this.storage != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSubresources instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomResourceSubresources getSubresources() {
    return this.subresources!=null ?this.subresources.build():null;
  }
  public CustomResourceSubresources buildSubresources() {
    return this.subresources!=null ?this.subresources.build():null;
  }
  public A withSubresources(CustomResourceSubresources subresources) {
    _visitables.get("subresources").remove(this.subresources);
    if (subresources!=null){ this.subresources= new CustomResourceSubresourcesBuilder(subresources); _visitables.get("subresources").add(this.subresources);} else { this.subresources = null; _visitables.get("subresources").remove(this.subresources); } return (A) this;
  }
  public Boolean hasSubresources() {
    return this.subresources != null;
  }
  public CustomResourceDefinitionVersionFluentImpl.SubresourcesNested<A> withNewSubresources() {
    return new CustomResourceDefinitionVersionFluentImpl.SubresourcesNestedImpl();
  }
  public CustomResourceDefinitionVersionFluentImpl.SubresourcesNested<A> withNewSubresourcesLike(CustomResourceSubresources item) {
    return new CustomResourceDefinitionVersionFluentImpl.SubresourcesNestedImpl(item);
  }
  public CustomResourceDefinitionVersionFluentImpl.SubresourcesNested<A> editSubresources() {
    return withNewSubresourcesLike(getSubresources());
  }
  public CustomResourceDefinitionVersionFluentImpl.SubresourcesNested<A> editOrNewSubresources() {
    return withNewSubresourcesLike(getSubresources() != null ? getSubresources(): new CustomResourceSubresourcesBuilder().build());
  }
  public CustomResourceDefinitionVersionFluentImpl.SubresourcesNested<A> editOrNewSubresourcesLike(CustomResourceSubresources item) {
    return withNewSubresourcesLike(getSubresources() != null ? getSubresources(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomResourceDefinitionVersionFluentImpl that = (CustomResourceDefinitionVersionFluentImpl) o;
    if (!java.util.Objects.equals(additionalPrinterColumns, that.additionalPrinterColumns)) return false;

    if (!java.util.Objects.equals(deprecated, that.deprecated)) return false;

    if (!java.util.Objects.equals(deprecationWarning, that.deprecationWarning)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(schema, that.schema)) return false;

    if (!java.util.Objects.equals(served, that.served)) return false;

    if (!java.util.Objects.equals(storage, that.storage)) return false;

    if (!java.util.Objects.equals(subresources, that.subresources)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalPrinterColumns,  deprecated,  deprecationWarning,  name,  schema,  served,  storage,  subresources,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalPrinterColumns != null) { sb.append("additionalPrinterColumns:"); sb.append(additionalPrinterColumns + ","); }
    if (deprecated != null) { sb.append("deprecated:"); sb.append(deprecated + ","); }
    if (deprecationWarning != null) { sb.append("deprecationWarning:"); sb.append(deprecationWarning + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (schema != null) { sb.append("schema:"); sb.append(schema + ","); }
    if (served != null) { sb.append("served:"); sb.append(served + ","); }
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (subresources != null) { sb.append("subresources:"); sb.append(subresources + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withDeprecated() {
    return withDeprecated(true);
  }
  public A withServed() {
    return withServed(true);
  }
  public A withStorage() {
    return withStorage(true);
  }
  class AdditionalPrinterColumnsNestedImpl<N> extends CustomResourceColumnDefinitionFluentImpl<CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNested<N>> implements CustomResourceDefinitionVersionFluentImpl.AdditionalPrinterColumnsNested<N>,Nested<N>{
    AdditionalPrinterColumnsNestedImpl(int index,CustomResourceColumnDefinition item) {
      this.index = index;
      this.builder = new CustomResourceColumnDefinitionBuilder(this, item);
    }
    AdditionalPrinterColumnsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceColumnDefinitionBuilder(this);
    }
    CustomResourceColumnDefinitionBuilder builder;
    int index;
    public N and() {
      return (N) CustomResourceDefinitionVersionFluentImpl.this.setToAdditionalPrinterColumns(index,builder.build());
    }
    public N endAdditionalPrinterColumn() {
      return and();
    }
    
  }
  class SchemaNestedImpl<N> extends CustomResourceValidationFluentImpl<CustomResourceDefinitionVersionFluentImpl.SchemaNested<N>> implements CustomResourceDefinitionVersionFluentImpl.SchemaNested<N>,Nested<N>{
    SchemaNestedImpl(CustomResourceValidation item) {
      this.builder = new CustomResourceValidationBuilder(this, item);
    }
    SchemaNestedImpl() {
      this.builder = new CustomResourceValidationBuilder(this);
    }
    CustomResourceValidationBuilder builder;
    public N and() {
      return (N) CustomResourceDefinitionVersionFluentImpl.this.withSchema(builder.build());
    }
    public N endSchema() {
      return and();
    }
    
  }
  class SubresourcesNestedImpl<N> extends CustomResourceSubresourcesFluentImpl<CustomResourceDefinitionVersionFluentImpl.SubresourcesNested<N>> implements CustomResourceDefinitionVersionFluentImpl.SubresourcesNested<N>,Nested<N>{
    SubresourcesNestedImpl(CustomResourceSubresources item) {
      this.builder = new CustomResourceSubresourcesBuilder(this, item);
    }
    SubresourcesNestedImpl() {
      this.builder = new CustomResourceSubresourcesBuilder(this);
    }
    CustomResourceSubresourcesBuilder builder;
    public N and() {
      return (N) CustomResourceDefinitionVersionFluentImpl.this.withSubresources(builder.build());
    }
    public N endSubresources() {
      return and();
    }
    
  }
  
}