package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceValidationBuilder extends CustomResourceValidationFluentImpl<CustomResourceValidationBuilder> implements VisitableBuilder<CustomResourceValidation,CustomResourceValidationBuilder>{
  public CustomResourceValidationBuilder() {
    this(false);
  }
  public CustomResourceValidationBuilder(Boolean validationEnabled) {
    this(new CustomResourceValidation(), validationEnabled);
  }
  public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceValidation(), validationEnabled);
  }
  public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent,CustomResourceValidation instance) {
    this(fluent, instance, false);
  }
  public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent,CustomResourceValidation instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceValidationBuilder(CustomResourceValidation instance) {
    this(instance,false);
  }
  public CustomResourceValidationBuilder(CustomResourceValidation instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CustomResourceValidationFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceValidation build() {
    CustomResourceValidation buildable = new CustomResourceValidation(fluent.getOpenAPIV3Schema());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}