package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebhookClientConfigBuilder extends WebhookClientConfigFluentImpl<WebhookClientConfigBuilder> implements VisitableBuilder<WebhookClientConfig,WebhookClientConfigBuilder>{
  public WebhookClientConfigBuilder() {
    this(false);
  }
  public WebhookClientConfigBuilder(Boolean validationEnabled) {
    this(new WebhookClientConfig(), validationEnabled);
  }
  public WebhookClientConfigBuilder(WebhookClientConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public WebhookClientConfigBuilder(WebhookClientConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WebhookClientConfig(), validationEnabled);
  }
  public WebhookClientConfigBuilder(WebhookClientConfigFluent<?> fluent,WebhookClientConfig instance) {
    this(fluent, instance, false);
  }
  public WebhookClientConfigBuilder(WebhookClientConfigFluent<?> fluent,WebhookClientConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withService(instance.getService());
      fluent.withUrl(instance.getUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WebhookClientConfigBuilder(WebhookClientConfig instance) {
    this(instance,false);
  }
  public WebhookClientConfigBuilder(WebhookClientConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCaBundle(instance.getCaBundle());
      this.withService(instance.getService());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  WebhookClientConfigFluent<?> fluent;
  Boolean validationEnabled;
  public WebhookClientConfig build() {
    WebhookClientConfig buildable = new WebhookClientConfig(fluent.getCaBundle(),fluent.getService(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}