package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceSubresourceScaleBuilder extends CustomResourceSubresourceScaleFluentImpl<CustomResourceSubresourceScaleBuilder> implements VisitableBuilder<CustomResourceSubresourceScale,CustomResourceSubresourceScaleBuilder>{
  public CustomResourceSubresourceScaleBuilder() {
    this(false);
  }
  public CustomResourceSubresourceScaleBuilder(Boolean validationEnabled) {
    this(new CustomResourceSubresourceScale(), validationEnabled);
  }
  public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScaleFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScaleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceSubresourceScale(), validationEnabled);
  }
  public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScaleFluent<?> fluent,CustomResourceSubresourceScale instance) {
    this(fluent, instance, false);
  }
  public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScaleFluent<?> fluent,CustomResourceSubresourceScale instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLabelSelectorPath(instance.getLabelSelectorPath());
      fluent.withSpecReplicasPath(instance.getSpecReplicasPath());
      fluent.withStatusReplicasPath(instance.getStatusReplicasPath());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScale instance) {
    this(instance,false);
  }
  public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScale instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLabelSelectorPath(instance.getLabelSelectorPath());
      this.withSpecReplicasPath(instance.getSpecReplicasPath());
      this.withStatusReplicasPath(instance.getStatusReplicasPath());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CustomResourceSubresourceScaleFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceSubresourceScale build() {
    CustomResourceSubresourceScale buildable = new CustomResourceSubresourceScale(fluent.getLabelSelectorPath(),fluent.getSpecReplicasPath(),fluent.getStatusReplicasPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}