package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceSubresourcesBuilder extends CustomResourceSubresourcesFluentImpl<CustomResourceSubresourcesBuilder> implements VisitableBuilder<CustomResourceSubresources,CustomResourceSubresourcesBuilder>{
  public CustomResourceSubresourcesBuilder() {
    this(false);
  }
  public CustomResourceSubresourcesBuilder(Boolean validationEnabled) {
    this(new CustomResourceSubresources(), validationEnabled);
  }
  public CustomResourceSubresourcesBuilder(CustomResourceSubresourcesFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceSubresourcesBuilder(CustomResourceSubresourcesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceSubresources(), validationEnabled);
  }
  public CustomResourceSubresourcesBuilder(CustomResourceSubresourcesFluent<?> fluent,CustomResourceSubresources instance) {
    this(fluent, instance, false);
  }
  public CustomResourceSubresourcesBuilder(CustomResourceSubresourcesFluent<?> fluent,CustomResourceSubresources instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withScale(instance.getScale());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceSubresourcesBuilder(CustomResourceSubresources instance) {
    this(instance,false);
  }
  public CustomResourceSubresourcesBuilder(CustomResourceSubresources instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withScale(instance.getScale());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CustomResourceSubresourcesFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceSubresources build() {
    CustomResourceSubresources buildable = new CustomResourceSubresources(fluent.getScale(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}