package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebhookConversionBuilder extends WebhookConversionFluent<WebhookConversionBuilder> implements VisitableBuilder<WebhookConversion,WebhookConversionBuilder>{
  public WebhookConversionBuilder() {
    this(false);
  }
  public WebhookConversionBuilder(Boolean validationEnabled) {
    this(new WebhookConversion(), validationEnabled);
  }
  public WebhookConversionBuilder(WebhookConversionFluent<?> fluent) {
    this(fluent, false);
  }
  public WebhookConversionBuilder(WebhookConversionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WebhookConversion(), validationEnabled);
  }
  public WebhookConversionBuilder(WebhookConversionFluent<?> fluent,WebhookConversion instance) {
    this(fluent, instance, false);
  }
  public WebhookConversionBuilder(WebhookConversionFluent<?> fluent,WebhookConversion instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WebhookConversion());

    if (instance != null) {
      fluent.withClientConfig(instance.getClientConfig());
      fluent.withConversionReviewVersions(instance.getConversionReviewVersions());
      fluent.withClientConfig(instance.getClientConfig());
      fluent.withConversionReviewVersions(instance.getConversionReviewVersions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WebhookConversionBuilder(WebhookConversion instance) {
    this(instance,false);
  }
  public WebhookConversionBuilder(WebhookConversion instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WebhookConversion());

    if (instance != null) {
      this.withClientConfig(instance.getClientConfig());
      this.withConversionReviewVersions(instance.getConversionReviewVersions());
      this.withClientConfig(instance.getClientConfig());
      this.withConversionReviewVersions(instance.getConversionReviewVersions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  WebhookConversionFluent<?> fluent;
  Boolean validationEnabled;
  public WebhookConversion build() {
    WebhookConversion buildable = new WebhookConversion(fluent.buildClientConfig(),fluent.getConversionReviewVersions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}