package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceDefinitionBuilder extends CustomResourceDefinitionFluent<CustomResourceDefinitionBuilder> implements VisitableBuilder<CustomResourceDefinition,CustomResourceDefinitionBuilder>{
  public CustomResourceDefinitionBuilder() {
    this(false);
  }
  public CustomResourceDefinitionBuilder(Boolean validationEnabled) {
    this(new CustomResourceDefinition(), validationEnabled);
  }
  public CustomResourceDefinitionBuilder(CustomResourceDefinitionFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceDefinitionBuilder(CustomResourceDefinitionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceDefinition(), validationEnabled);
  }
  public CustomResourceDefinitionBuilder(CustomResourceDefinitionFluent<?> fluent,CustomResourceDefinition instance) {
    this(fluent, instance, false);
  }
  public CustomResourceDefinitionBuilder(CustomResourceDefinitionFluent<?> fluent,CustomResourceDefinition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CustomResourceDefinition());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceDefinitionBuilder(CustomResourceDefinition instance) {
    this(instance,false);
  }
  public CustomResourceDefinitionBuilder(CustomResourceDefinition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CustomResourceDefinition());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CustomResourceDefinitionFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceDefinition build() {
    CustomResourceDefinition buildable = new CustomResourceDefinition(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}