package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JSONSchemaPropsOrArrayFluent<A extends JSONSchemaPropsOrArrayFluent<A>> extends BaseFluent<A>{
  public JSONSchemaPropsOrArrayFluent() {
  }
  
  public JSONSchemaPropsOrArrayFluent(JSONSchemaPropsOrArray instance) {
    this.copyInstance(instance);
  }
  private ArrayList<JSONSchemaPropsBuilder> jSONSchemas = new ArrayList<JSONSchemaPropsBuilder>();
  private JSONSchemaPropsBuilder schema;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(JSONSchemaPropsOrArray instance) {
    instance = (instance != null ? instance : new JSONSchemaPropsOrArray());
    if (instance != null) {
          this.withJSONSchemas(instance.getJSONSchemas());
          this.withSchema(instance.getSchema());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToJSONSchemas(int index,JSONSchemaProps item) {
    if (this.jSONSchemas == null) {this.jSONSchemas = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= jSONSchemas.size()) {
        _visitables.get("jSONSchemas").add(builder);
        jSONSchemas.add(builder);
    } else {
        _visitables.get("jSONSchemas").add(builder);
        jSONSchemas.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToJSONSchemas(int index,JSONSchemaProps item) {
    if (this.jSONSchemas == null) {this.jSONSchemas = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= jSONSchemas.size()) {
        _visitables.get("jSONSchemas").add(builder);
        jSONSchemas.add(builder);
    } else {
        _visitables.get("jSONSchemas").add(builder);
        jSONSchemas.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToJSONSchemas(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... items) {
    if (this.jSONSchemas == null) {this.jSONSchemas = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("jSONSchemas").add(builder);this.jSONSchemas.add(builder);} return (A)this;
  }
  
  public A addAllToJSONSchemas(Collection<JSONSchemaProps> items) {
    if (this.jSONSchemas == null) {this.jSONSchemas = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("jSONSchemas").add(builder);this.jSONSchemas.add(builder);} return (A)this;
  }
  
  public A removeFromJSONSchemas(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... items) {
    if (this.jSONSchemas == null) return (A)this;
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("jSONSchemas").remove(builder); this.jSONSchemas.remove(builder);} return (A)this;
  }
  
  public A removeAllFromJSONSchemas(Collection<JSONSchemaProps> items) {
    if (this.jSONSchemas == null) return (A)this;
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("jSONSchemas").remove(builder); this.jSONSchemas.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromJSONSchemas(Predicate<JSONSchemaPropsBuilder> predicate) {
    if (jSONSchemas == null) return (A) this;
    final Iterator<JSONSchemaPropsBuilder> each = jSONSchemas.iterator();
    final List visitables = _visitables.get("jSONSchemas");
    while (each.hasNext()) {
      JSONSchemaPropsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<JSONSchemaProps> buildJSONSchemas() {
    return this.jSONSchemas != null ? build(jSONSchemas) : null;
  }
  
  public JSONSchemaProps buildJSONSchema(int index) {
    return this.jSONSchemas.get(index).build();
  }
  
  public JSONSchemaProps buildFirstJSONSchema() {
    return this.jSONSchemas.get(0).build();
  }
  
  public JSONSchemaProps buildLastJSONSchema() {
    return this.jSONSchemas.get(jSONSchemas.size() - 1).build();
  }
  
  public JSONSchemaProps buildMatchingJSONSchema(Predicate<JSONSchemaPropsBuilder> predicate) {
      for (JSONSchemaPropsBuilder item : jSONSchemas) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingJSONSchema(Predicate<JSONSchemaPropsBuilder> predicate) {
      for (JSONSchemaPropsBuilder item : jSONSchemas) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withJSONSchemas(List<JSONSchemaProps> jSONSchemas) {
    if (this.jSONSchemas != null) {
      this._visitables.get("jSONSchemas").clear();
    }
    if (jSONSchemas != null) {
        this.jSONSchemas = new ArrayList();
        for (JSONSchemaProps item : jSONSchemas) {
          this.addToJSONSchemas(item);
        }
    } else {
      this.jSONSchemas = null;
    }
    return (A) this;
  }
  
  public A withJSONSchemas(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... jSONSchemas) {
    if (this.jSONSchemas != null) {
        this.jSONSchemas.clear();
        _visitables.remove("jSONSchemas");
    }
    if (jSONSchemas != null) {
      for (JSONSchemaProps item : jSONSchemas) {
        this.addToJSONSchemas(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasJSONSchemas() {
    return this.jSONSchemas != null && !this.jSONSchemas.isEmpty();
  }
  
  public JSONSchemasNested<A> addNewJSONSchema() {
    return new JSONSchemasNested(-1, null);
  }
  
  public JSONSchemasNested<A> addNewJSONSchemaLike(JSONSchemaProps item) {
    return new JSONSchemasNested(-1, item);
  }
  
  public JSONSchemasNested<A> setNewJSONSchemaLike(int index,JSONSchemaProps item) {
    return new JSONSchemasNested(index, item);
  }
  
  public JSONSchemasNested<A> editJSONSchema(int index) {
    if (jSONSchemas.size() <= index) throw new RuntimeException("Can't edit jSONSchemas. Index exceeds size.");
    return setNewJSONSchemaLike(index, buildJSONSchema(index));
  }
  
  public JSONSchemasNested<A> editFirstJSONSchema() {
    if (jSONSchemas.size() == 0) throw new RuntimeException("Can't edit first jSONSchemas. The list is empty.");
    return setNewJSONSchemaLike(0, buildJSONSchema(0));
  }
  
  public JSONSchemasNested<A> editLastJSONSchema() {
    int index = jSONSchemas.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last jSONSchemas. The list is empty.");
    return setNewJSONSchemaLike(index, buildJSONSchema(index));
  }
  
  public JSONSchemasNested<A> editMatchingJSONSchema(Predicate<JSONSchemaPropsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<jSONSchemas.size();i++) { 
    if (predicate.test(jSONSchemas.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching jSONSchemas. No match found.");
    return setNewJSONSchemaLike(index, buildJSONSchema(index));
  }
  
  public JSONSchemaProps buildSchema() {
    return this.schema != null ? this.schema.build() : null;
  }
  
  public A withSchema(JSONSchemaProps schema) {
    this._visitables.remove("schema");
    if (schema != null) {
        this.schema = new JSONSchemaPropsBuilder(schema);
        this._visitables.get("schema").add(this.schema);
    } else {
        this.schema = null;
        this._visitables.get("schema").remove(this.schema);
    }
    return (A) this;
  }
  
  public boolean hasSchema() {
    return this.schema != null;
  }
  
  public SchemaNested<A> withNewSchema() {
    return new SchemaNested(null);
  }
  
  public SchemaNested<A> withNewSchemaLike(JSONSchemaProps item) {
    return new SchemaNested(item);
  }
  
  public SchemaNested<A> editSchema() {
    return withNewSchemaLike(java.util.Optional.ofNullable(buildSchema()).orElse(null));
  }
  
  public SchemaNested<A> editOrNewSchema() {
    return withNewSchemaLike(java.util.Optional.ofNullable(buildSchema()).orElse(new JSONSchemaPropsBuilder().build()));
  }
  
  public SchemaNested<A> editOrNewSchemaLike(JSONSchemaProps item) {
    return withNewSchemaLike(java.util.Optional.ofNullable(buildSchema()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JSONSchemaPropsOrArrayFluent that = (JSONSchemaPropsOrArrayFluent) o;
    if (!java.util.Objects.equals(jSONSchemas, that.jSONSchemas)) return false;
    if (!java.util.Objects.equals(schema, that.schema)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(jSONSchemas,  schema,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (jSONSchemas != null && !jSONSchemas.isEmpty()) { sb.append("jSONSchemas:"); sb.append(jSONSchemas + ","); }
    if (schema != null) { sb.append("schema:"); sb.append(schema + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class JSONSchemasNested<N> extends JSONSchemaPropsFluent<JSONSchemasNested<N>> implements Nested<N>{
    JSONSchemasNested(int index,JSONSchemaProps item) {
      this.index = index;
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    JSONSchemaPropsBuilder builder;
    int index;
    
    public N and() {
      return (N) JSONSchemaPropsOrArrayFluent.this.setToJSONSchemas(index,builder.build());
    }
    
    public N endJSONSchema() {
      return and();
    }
    
  
  }
  public class SchemaNested<N> extends JSONSchemaPropsFluent<SchemaNested<N>> implements Nested<N>{
    SchemaNested(JSONSchemaProps item) {
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    JSONSchemaPropsBuilder builder;
    
    public N and() {
      return (N) JSONSchemaPropsOrArrayFluent.this.withSchema(builder.build());
    }
    
    public N endSchema() {
      return and();
    }
    
  
  }

}