package io.fabric8.kubernetes.api.model.apps;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import java.util.Map;

public interface ControllerRevisionFluent<A extends ControllerRevisionFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildData instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getData();
    public HasMetadata buildData();
    public A withData(HasMetadata data);
    public Boolean hasData();
    public A withReplicaSetData(ReplicaSet replicaSetData);
    public ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetData();
    public ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetDataLike(ReplicaSet item);
    public A withDaemonSetData(DaemonSet daemonSetData);
    public ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetData();
    public ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetDataLike(DaemonSet item);
    public A withControllerRevisionData(ControllerRevision controllerRevisionData);
    public ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionData();
    public ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionDataLike(ControllerRevision item);
    public A withStatefulSetData(StatefulSet statefulSetData);
    public ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetData();
    public ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetDataLike(StatefulSet item);
    public A withPersistentVolumeClaimData(PersistentVolumeClaim persistentVolumeClaimData);
    public ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimData();
    public ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimDataLike(PersistentVolumeClaim item);
    public A withDeploymentData(Deployment deploymentData);
    public ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentData();
    public ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentDataLike(Deployment item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ControllerRevisionFluent.MetadataNested<A> withNewMetadata();
    public ControllerRevisionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ControllerRevisionFluent.MetadataNested<A> editMetadata();
    public ControllerRevisionFluent.MetadataNested<A> editOrNewMetadata();
    public ControllerRevisionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public Long getRevision();
    public A withRevision(Long revision);
    public Boolean hasRevision();
    public interface ReplicaSetDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicaSetFluent<ControllerRevisionFluent.ReplicaSetDataNested<N>> {

        public N and();
        public N endReplicaSetData();    }


    public interface DaemonSetDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DaemonSetFluent<ControllerRevisionFluent.DaemonSetDataNested<N>> {

        public N and();
        public N endDaemonSetData();    }


    public interface ControllerRevisionDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ControllerRevisionFluent<ControllerRevisionFluent.ControllerRevisionDataNested<N>> {

        public N and();
        public N endControllerRevisionData();    }


    public interface StatefulSetDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StatefulSetFluent<ControllerRevisionFluent.StatefulSetDataNested<N>> {

        public N and();
        public N endStatefulSetData();    }


    public interface PersistentVolumeClaimDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>> {

        public N and();
        public N endPersistentVolumeClaimData();    }


    public interface DeploymentDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentFluent<ControllerRevisionFluent.DeploymentDataNested<N>> {

        public N and();
        public N endDeploymentData();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ControllerRevisionFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


}
