package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface DeploymentListFluent<A extends DeploymentListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Deployment item);
    public A setToItems(int index,Deployment item);
    public A addToItems(Deployment... items);
    public A addAllToItems(Collection<Deployment> items);
    public A removeFromItems(Deployment... items);
    public A removeAllFromItems(Collection<Deployment> items);
    public A removeMatchingFromItems(Predicate<DeploymentBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Deployment> getItems();
    public List<Deployment> buildItems();
    public Deployment buildItem(int index);
    public Deployment buildFirstItem();
    public Deployment buildLastItem();
    public Deployment buildMatchingItem(Predicate<DeploymentBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<DeploymentBuilder> predicate);
    public A withItems(List<Deployment> items);
    public A withItems(Deployment... items);
    public Boolean hasItems();
    public DeploymentListFluent.ItemsNested<A> addNewItem();
    public DeploymentListFluent.ItemsNested<A> addNewItemLike(Deployment item);
    public DeploymentListFluent.ItemsNested<A> setNewItemLike(int index,Deployment item);
    public DeploymentListFluent.ItemsNested<A> editItem(int index);
    public DeploymentListFluent.ItemsNested<A> editFirstItem();
    public DeploymentListFluent.ItemsNested<A> editLastItem();
    public DeploymentListFluent.ItemsNested<A> editMatchingItem(Predicate<DeploymentBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentFluent<DeploymentListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
