package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class DeploymentStatusBuilder extends io.fabric8.kubernetes.api.model.apps.DeploymentStatusFluentImpl<io.fabric8.kubernetes.api.model.apps.DeploymentStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apps.DeploymentStatus,io.fabric8.kubernetes.api.model.apps.DeploymentStatusBuilder>{
  public DeploymentStatusBuilder() {
    this(false);
  }
  public DeploymentStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new DeploymentStatus(), validationEnabled);
  }
  public DeploymentStatusBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentStatusBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentStatus(), validationEnabled);
  }
  public DeploymentStatusBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DeploymentStatus instance) {
    this(fluent, instance, false);
  }
  public DeploymentStatusBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DeploymentStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
    fluent.withCollisionCount(instance.getCollisionCount()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withReadyReplicas(instance.getReadyReplicas()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentStatusBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStatus instance) {
    this(instance,false);
  }
  public DeploymentStatusBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withCollisionCount(instance.getCollisionCount()); 
    this.withConditions(instance.getConditions()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.DeploymentStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.DeploymentStatus build() {
    DeploymentStatus buildable = new DeploymentStatus(fluent.getAvailableReplicas(),fluent.getCollisionCount(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeploymentStatusBuilder that = (DeploymentStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}