package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class StatefulSetStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent<A>{
  public StatefulSetStatusFluentImpl() {
  }
  public StatefulSetStatusFluentImpl(io.fabric8.kubernetes.api.model.apps.StatefulSetStatus instance) {
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withCollisionCount(instance.getCollisionCount()); 
    this.withConditions(instance.getConditions()); 
    this.withCurrentReplicas(instance.getCurrentReplicas()); 
    this.withCurrentRevision(instance.getCurrentRevision()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUpdateRevision(instance.getUpdateRevision()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.Integer availableReplicas;
  private java.lang.Integer collisionCount;
  private java.util.List<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder>();
  private java.lang.Integer currentReplicas;
  private java.lang.String currentRevision;
  private java.lang.Long observedGeneration;
  private java.lang.Integer readyReplicas;
  private java.lang.Integer replicas;
  private java.lang.String updateRevision;
  private java.lang.Integer updatedReplicas;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.Integer getAvailableReplicas() {
    return this.availableReplicas;
  }
  public A withAvailableReplicas(java.lang.Integer availableReplicas) {
    this.availableReplicas=availableReplicas; return (A) this;
  }
  public java.lang.Boolean hasAvailableReplicas() {
    return this.availableReplicas != null;
  }
  public java.lang.Integer getCollisionCount() {
    return this.collisionCount;
  }
  public A withCollisionCount(java.lang.Integer collisionCount) {
    this.collisionCount=collisionCount; return (A) this;
  }
  public java.lang.Boolean hasCollisionCount() {
    return this.collisionCount != null;
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder>();}
    io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder>();}
    io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item : items) {io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.apps.StatefulSetCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item : items) {io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition... items) {
    for (io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item : items) {io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.apps.StatefulSetCondition> items) {
    for (io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item : items) {io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.apps.StatefulSetCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.apps.StatefulSetCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.apps.StatefulSetCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
    return (A)addToConditions(new StatefulSetCondition(lastTransitionTime, message, reason, status, type));
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.Integer getCurrentReplicas() {
    return this.currentReplicas;
  }
  public A withCurrentReplicas(java.lang.Integer currentReplicas) {
    this.currentReplicas=currentReplicas; return (A) this;
  }
  public java.lang.Boolean hasCurrentReplicas() {
    return this.currentReplicas != null;
  }
  public java.lang.String getCurrentRevision() {
    return this.currentRevision;
  }
  public A withCurrentRevision(java.lang.String currentRevision) {
    this.currentRevision=currentRevision; return (A) this;
  }
  public java.lang.Boolean hasCurrentRevision() {
    return this.currentRevision != null;
  }
  
  /**
   * Method is deprecated. use withCurrentRevision instead.
   */
  @java.lang.Deprecated
  public A withNewCurrentRevision(java.lang.String arg0) {
    return (A)withCurrentRevision(new String(arg0));
  }
  public java.lang.Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(java.lang.Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public java.lang.Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public java.lang.Integer getReadyReplicas() {
    return this.readyReplicas;
  }
  public A withReadyReplicas(java.lang.Integer readyReplicas) {
    this.readyReplicas=readyReplicas; return (A) this;
  }
  public java.lang.Boolean hasReadyReplicas() {
    return this.readyReplicas != null;
  }
  public java.lang.Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(java.lang.Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public java.lang.Boolean hasReplicas() {
    return this.replicas != null;
  }
  public java.lang.String getUpdateRevision() {
    return this.updateRevision;
  }
  public A withUpdateRevision(java.lang.String updateRevision) {
    this.updateRevision=updateRevision; return (A) this;
  }
  public java.lang.Boolean hasUpdateRevision() {
    return this.updateRevision != null;
  }
  
  /**
   * Method is deprecated. use withUpdateRevision instead.
   */
  @java.lang.Deprecated
  public A withNewUpdateRevision(java.lang.String arg0) {
    return (A)withUpdateRevision(new String(arg0));
  }
  public java.lang.Integer getUpdatedReplicas() {
    return this.updatedReplicas;
  }
  public A withUpdatedReplicas(java.lang.Integer updatedReplicas) {
    this.updatedReplicas=updatedReplicas; return (A) this;
  }
  public java.lang.Boolean hasUpdatedReplicas() {
    return this.updatedReplicas != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StatefulSetStatusFluentImpl that = (StatefulSetStatusFluentImpl) o;
    if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
    if (collisionCount != null ? !collisionCount.equals(that.collisionCount) :that.collisionCount != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (currentReplicas != null ? !currentReplicas.equals(that.currentReplicas) :that.currentReplicas != null) return false;
    if (currentRevision != null ? !currentRevision.equals(that.currentRevision) :that.currentRevision != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (readyReplicas != null ? !readyReplicas.equals(that.readyReplicas) :that.readyReplicas != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (updateRevision != null ? !updateRevision.equals(that.updateRevision) :that.updateRevision != null) return false;
    if (updatedReplicas != null ? !updatedReplicas.equals(that.updatedReplicas) :that.updatedReplicas != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availableReplicas,  collisionCount,  conditions,  currentReplicas,  currentRevision,  observedGeneration,  readyReplicas,  replicas,  updateRevision,  updatedReplicas,  additionalProperties,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.apps.StatefulSetConditionFluentImpl<io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) StatefulSetStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}