package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface DaemonSetStatusFluent<A extends DaemonSetStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getCollisionCount();
    public A withCollisionCount(Integer collisionCount);
    public Boolean hasCollisionCount();
    public A withNewCollisionCount(int arg0);
    public A addToConditions(int index,DaemonSetCondition item);
    public A setToConditions(int index,DaemonSetCondition item);
    public A addToConditions(DaemonSetCondition... items);
    public A addAllToConditions(Collection<DaemonSetCondition> items);
    public A removeFromConditions(DaemonSetCondition... items);
    public A removeAllFromConditions(Collection<DaemonSetCondition> items);
    public A removeMatchingFromConditions(Predicate<DaemonSetConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<DaemonSetCondition> getConditions();
    public List<DaemonSetCondition> buildConditions();
    public DaemonSetCondition buildCondition(int index);
    public DaemonSetCondition buildFirstCondition();
    public DaemonSetCondition buildLastCondition();
    public DaemonSetCondition buildMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate);
    public A withConditions(List<DaemonSetCondition> conditions);
    public A withConditions(DaemonSetCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public io.fabric8.kubernetes.api.model.apps.DaemonSetStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.kubernetes.api.model.apps.DaemonSetStatusFluent.ConditionsNested<A> addNewConditionLike(DaemonSetCondition item);
    public io.fabric8.kubernetes.api.model.apps.DaemonSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index,DaemonSetCondition item);
    public io.fabric8.kubernetes.api.model.apps.DaemonSetStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.kubernetes.api.model.apps.DaemonSetStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.kubernetes.api.model.apps.DaemonSetStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.kubernetes.api.model.apps.DaemonSetStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate);
    public Integer getCurrentNumberScheduled();
    public A withCurrentNumberScheduled(Integer currentNumberScheduled);
    public Boolean hasCurrentNumberScheduled();
    public A withNewCurrentNumberScheduled(int arg0);
    public Integer getDesiredNumberScheduled();
    public A withDesiredNumberScheduled(Integer desiredNumberScheduled);
    public Boolean hasDesiredNumberScheduled();
    public A withNewDesiredNumberScheduled(int arg0);
    public Integer getNumberAvailable();
    public A withNumberAvailable(Integer numberAvailable);
    public Boolean hasNumberAvailable();
    public A withNewNumberAvailable(int arg0);
    public Integer getNumberMisscheduled();
    public A withNumberMisscheduled(Integer numberMisscheduled);
    public Boolean hasNumberMisscheduled();
    public A withNewNumberMisscheduled(int arg0);
    public Integer getNumberReady();
    public A withNumberReady(Integer numberReady);
    public Boolean hasNumberReady();
    public A withNewNumberReady(int arg0);
    public Integer getNumberUnavailable();
    public A withNumberUnavailable(Integer numberUnavailable);
    public Boolean hasNumberUnavailable();
    public A withNewNumberUnavailable(int arg0);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(long arg1);
    public Integer getUpdatedNumberScheduled();
    public A withUpdatedNumberScheduled(Integer updatedNumberScheduled);
    public Boolean hasUpdatedNumberScheduled();
    public A withNewUpdatedNumberScheduled(int arg0);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DaemonSetConditionFluent<io.fabric8.kubernetes.api.model.apps.DaemonSetStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


}
