package io.fabric8.kubernetes.api.model.apps;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import java.util.Map;

public interface ControllerRevisionFluent<A extends ControllerRevisionFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    
/**
 * This method has been deprecated, please use method buildData instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getData();
    public HasMetadata buildData();
    public A withData(HasMetadata data);
    public Boolean hasData();
    public A withReplicaSetData(ReplicaSet replicaSetData);
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetData();
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetDataLike(ReplicaSet item);
    public A withDaemonSetData(DaemonSet daemonSetData);
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetData();
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetDataLike(DaemonSet item);
    public A withControllerRevisionData(ControllerRevision controllerRevisionData);
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionData();
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionDataLike(ControllerRevision item);
    public A withStatefulSetData(StatefulSet statefulSetData);
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetData();
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetDataLike(StatefulSet item);
    public A withPersistentVolumeClaimData(PersistentVolumeClaim persistentVolumeClaimData);
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimData();
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimDataLike(PersistentVolumeClaim item);
    public A withDeploymentData(Deployment deploymentData);
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentData();
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentDataLike(Deployment item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> editMetadata();
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public Long getRevision();
    public A withRevision(Long revision);
    public Boolean hasRevision();
    public A withNewRevision(long arg1);
    public interface ReplicaSetDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicaSetFluent<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ReplicaSetDataNested<N>> {

            public N and();
            public N endReplicaSetData();    }


    public interface DaemonSetDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DaemonSetFluent<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DaemonSetDataNested<N>> {

            public N and();
            public N endDaemonSetData();    }


    public interface ControllerRevisionDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ControllerRevisionFluent<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ControllerRevisionDataNested<N>> {

            public N and();
            public N endControllerRevisionData();    }


    public interface StatefulSetDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StatefulSetFluent<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.StatefulSetDataNested<N>> {

            public N and();
            public N endStatefulSetData();    }


    public interface PersistentVolumeClaimDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>> {

            public N and();
            public N endPersistentVolumeClaimData();    }


    public interface DeploymentDataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentFluent<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DeploymentDataNested<N>> {

            public N and();
            public N endDeploymentData();    }


    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
