package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.lang.StringBuffer;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;

public class ControllerRevisionFluentImpl<A extends ControllerRevisionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ControllerRevisionFluent<A> {

    private String apiVersion;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends HasMetadata,?> data;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Long revision;

    public ControllerRevisionFluentImpl() {
    }

    public ControllerRevisionFluentImpl(ControllerRevision instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withData(instance.getData()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withRevision(instance.getRevision()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildData instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getData() {
        return this.data!=null?this.data.build():null;
    }

    public HasMetadata buildData() {
        return this.data!=null?this.data.build():null;
    }

    public A withData(HasMetadata data) {
        if (data instanceof ReplicaSet){ this.data= new ReplicaSetBuilder((ReplicaSet)data); _visitables.get("data").add(this.data);}
        if (data instanceof DaemonSet){ this.data= new DaemonSetBuilder((DaemonSet)data); _visitables.get("data").add(this.data);}
        if (data instanceof ControllerRevision){ this.data= new ControllerRevisionBuilder((ControllerRevision)data); _visitables.get("data").add(this.data);}
        if (data instanceof StatefulSet){ this.data= new StatefulSetBuilder((StatefulSet)data); _visitables.get("data").add(this.data);}
        if (data instanceof PersistentVolumeClaim){ this.data= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)data); _visitables.get("data").add(this.data);}
        if (data instanceof Deployment){ this.data= new DeploymentBuilder((Deployment)data); _visitables.get("data").add(this.data);}
        return (A) this;
    }

    public Boolean hasData() {
        return this.data != null;
    }

    public A withReplicaSetData(ReplicaSet replicaSetData) {
        _visitables.get("data").remove(this.data);
        if (replicaSetData!=null){ this.data= new ReplicaSetBuilder(replicaSetData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetData() {
        return new ReplicaSetDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetDataLike(ReplicaSet item) {
        return new ReplicaSetDataNestedImpl(item);
    }

    public A withDaemonSetData(DaemonSet daemonSetData) {
        _visitables.get("data").remove(this.data);
        if (daemonSetData!=null){ this.data= new DaemonSetBuilder(daemonSetData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetData() {
        return new DaemonSetDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetDataLike(DaemonSet item) {
        return new DaemonSetDataNestedImpl(item);
    }

    public A withControllerRevisionData(ControllerRevision controllerRevisionData) {
        _visitables.get("data").remove(this.data);
        if (controllerRevisionData!=null){ this.data= new ControllerRevisionBuilder(controllerRevisionData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionData() {
        return new ControllerRevisionDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionDataLike(ControllerRevision item) {
        return new ControllerRevisionDataNestedImpl(item);
    }

    public A withStatefulSetData(StatefulSet statefulSetData) {
        _visitables.get("data").remove(this.data);
        if (statefulSetData!=null){ this.data= new StatefulSetBuilder(statefulSetData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetData() {
        return new StatefulSetDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetDataLike(StatefulSet item) {
        return new StatefulSetDataNestedImpl(item);
    }

    public A withPersistentVolumeClaimData(PersistentVolumeClaim persistentVolumeClaimData) {
        _visitables.get("data").remove(this.data);
        if (persistentVolumeClaimData!=null){ this.data= new PersistentVolumeClaimBuilder(persistentVolumeClaimData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimData() {
        return new PersistentVolumeClaimDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimDataLike(PersistentVolumeClaim item) {
        return new PersistentVolumeClaimDataNestedImpl(item);
    }

    public A withDeploymentData(Deployment deploymentData) {
        _visitables.get("data").remove(this.data);
        if (deploymentData!=null){ this.data= new DeploymentBuilder(deploymentData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentData() {
        return new DeploymentDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentDataLike(Deployment item) {
        return new DeploymentDataNestedImpl(item);
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public Long getRevision() {
        return this.revision;
    }

    public A withRevision(Long revision) {
        this.revision=revision; return (A) this;
    }

    public Boolean hasRevision() {
        return this.revision != null;
    }

    public A withNewRevision(long arg1) {
        return (A)withRevision(new Long(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ControllerRevisionFluentImpl that = (ControllerRevisionFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (data != null ? !data.equals(that.data) :that.data != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  data,  kind,  metadata,  revision,  super.hashCode());
    }

    public class ReplicaSetDataNestedImpl<N> extends ReplicaSetFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ReplicaSetDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ReplicaSetDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReplicaSetBuilder builder;

            ReplicaSetDataNestedImpl(ReplicaSet item) {
                this.builder = new ReplicaSetBuilder(this, item);
                        
            }

            ReplicaSetDataNestedImpl() {
                this.builder = new ReplicaSetBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endReplicaSetData() {
                return and();
            }
    }


    public class DaemonSetDataNestedImpl<N> extends DaemonSetFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DaemonSetDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DaemonSetDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DaemonSetBuilder builder;

            DaemonSetDataNestedImpl(DaemonSet item) {
                this.builder = new DaemonSetBuilder(this, item);
                        
            }

            DaemonSetDataNestedImpl() {
                this.builder = new DaemonSetBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endDaemonSetData() {
                return and();
            }
    }


    public class ControllerRevisionDataNestedImpl<N> extends ControllerRevisionFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ControllerRevisionDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ControllerRevisionDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ControllerRevisionBuilder builder;

            ControllerRevisionDataNestedImpl(ControllerRevision item) {
                this.builder = new ControllerRevisionBuilder(this, item);
                        
            }

            ControllerRevisionDataNestedImpl() {
                this.builder = new ControllerRevisionBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endControllerRevisionData() {
                return and();
            }
    }


    public class StatefulSetDataNestedImpl<N> extends StatefulSetFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.StatefulSetDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.StatefulSetDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StatefulSetBuilder builder;

            StatefulSetDataNestedImpl(StatefulSet item) {
                this.builder = new StatefulSetBuilder(this, item);
                        
            }

            StatefulSetDataNestedImpl() {
                this.builder = new StatefulSetBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endStatefulSetData() {
                return and();
            }
    }


    public class PersistentVolumeClaimDataNestedImpl<N> extends PersistentVolumeClaimFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimBuilder builder;

            PersistentVolumeClaimDataNestedImpl(PersistentVolumeClaim item) {
                this.builder = new PersistentVolumeClaimBuilder(this, item);
                        
            }

            PersistentVolumeClaimDataNestedImpl() {
                this.builder = new PersistentVolumeClaimBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endPersistentVolumeClaimData() {
                return and();
            }
    }


    public class DeploymentDataNestedImpl<N> extends DeploymentFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DeploymentDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DeploymentDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DeploymentBuilder builder;

            DeploymentDataNestedImpl(Deployment item) {
                this.builder = new DeploymentBuilder(this, item);
                        
            }

            DeploymentDataNestedImpl() {
                this.builder = new DeploymentBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endDeploymentData() {
                return and();
            }
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
