package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface DeploymentSpecFluent<A extends DeploymentSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean hasMinReadySeconds();
    public A withNewMinReadySeconds(int arg0);
    public Boolean getPaused();
    public A withPaused(Boolean paused);
    public Boolean hasPaused();
    public A withNewPaused(String arg1);
    public A withNewPaused(boolean arg1);
    public Integer getProgressDeadlineSeconds();
    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds);
    public Boolean hasProgressDeadlineSeconds();
    public A withNewProgressDeadlineSeconds(int arg0);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg0);
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public Boolean hasRevisionHistoryLimit();
    public A withNewRevisionHistoryLimit(int arg0);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.SelectorNested<A> withNewSelector();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.SelectorNested<A> editSelector();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.SelectorNested<A> editOrNewSelector();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public DeploymentStrategy getStrategy();
    public DeploymentStrategy buildStrategy();
    public A withStrategy(DeploymentStrategy strategy);
    public Boolean hasStrategy();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.StrategyNested<A> withNewStrategy();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item);
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.StrategyNested<A> editStrategy();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.StrategyNested<A> editOrNewStrategy();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplateSpec getTemplate();
    public PodTemplateSpec buildTemplate();
    public A withTemplate(PodTemplateSpec template);
    public Boolean hasTemplate();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.TemplateNested<A> withNewTemplate();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.TemplateNested<A> editTemplate();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.TemplateNested<A> editOrNewTemplate();
    public io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.SelectorNested<N>> {

            public N and();
            public N endSelector();    }


    public interface StrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentStrategyFluent<io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.StrategyNested<N>> {

            public N and();
            public N endStrategy();    }


    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


}
