package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DeploymentListBuilder extends io.fabric8.kubernetes.api.model.apps.DeploymentListFluentImpl<io.fabric8.kubernetes.api.model.apps.DeploymentListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apps.DeploymentList,io.fabric8.kubernetes.api.model.apps.DeploymentListBuilder> {

    io.fabric8.kubernetes.api.model.apps.DeploymentListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public DeploymentListBuilder() {
        this(true);
    }

    public DeploymentListBuilder(java.lang.Boolean validationEnabled) {
        this(new DeploymentList(), validationEnabled);
    }

    public DeploymentListBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentListFluent<?> fluent) {
        this(fluent, true);
    }

    public DeploymentListBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new DeploymentList(), validationEnabled);
    }

    public DeploymentListBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentListFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DeploymentList instance) {
        this(fluent, instance, true);
    }

    public DeploymentListBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentListFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DeploymentList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public DeploymentListBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentList instance) {
        this(instance,true);
    }

    public DeploymentListBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.apps.DeploymentList build() {
        DeploymentList buildable = new DeploymentList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DeploymentListBuilder that = (DeploymentListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
