package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DeploymentStrategyBuilder extends io.fabric8.kubernetes.api.model.apps.DeploymentStrategyFluentImpl<io.fabric8.kubernetes.api.model.apps.DeploymentStrategyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apps.DeploymentStrategy,io.fabric8.kubernetes.api.model.apps.DeploymentStrategyBuilder> {

    io.fabric8.kubernetes.api.model.apps.DeploymentStrategyFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public DeploymentStrategyBuilder() {
        this(true);
    }

    public DeploymentStrategyBuilder(java.lang.Boolean validationEnabled) {
        this(new DeploymentStrategy(), validationEnabled);
    }

    public DeploymentStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStrategyFluent<?> fluent) {
        this(fluent, true);
    }

    public DeploymentStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStrategyFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new DeploymentStrategy(), validationEnabled);
    }

    public DeploymentStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStrategyFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DeploymentStrategy instance) {
        this(fluent, instance, true);
    }

    public DeploymentStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStrategyFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DeploymentStrategy instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withRollingUpdate(instance.getRollingUpdate()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public DeploymentStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStrategy instance) {
        this(instance,true);
    }

    public DeploymentStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentStrategy instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withRollingUpdate(instance.getRollingUpdate()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.apps.DeploymentStrategy build() {
        DeploymentStrategy buildable = new DeploymentStrategy(fluent.getRollingUpdate(),fluent.getType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DeploymentStrategyBuilder that = (DeploymentStrategyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
