package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReplicaSetListBuilder extends io.fabric8.kubernetes.api.model.apps.ReplicaSetListFluentImpl<io.fabric8.kubernetes.api.model.apps.ReplicaSetListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apps.ReplicaSetList,io.fabric8.kubernetes.api.model.apps.ReplicaSetListBuilder> {

    io.fabric8.kubernetes.api.model.apps.ReplicaSetListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ReplicaSetListBuilder() {
        this(true);
    }

    public ReplicaSetListBuilder(java.lang.Boolean validationEnabled) {
        this(new ReplicaSetList(), validationEnabled);
    }

    public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetListFluent<?> fluent) {
        this(fluent, true);
    }

    public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ReplicaSetList(), validationEnabled);
    }

    public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.ReplicaSetList instance) {
        this(fluent, instance, true);
    }

    public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.ReplicaSetList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetList instance) {
        this(instance,true);
    }

    public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.apps.ReplicaSetList build() {
        ReplicaSetList buildable = new ReplicaSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ReplicaSetListBuilder that = (ReplicaSetListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
