package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

public interface StatefulSetSpecFluent<A extends io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getPodManagementPolicy();
    public A withPodManagementPolicy(java.lang.String podManagementPolicy);
    public java.lang.Boolean hasPodManagementPolicy();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPodManagementPolicy instead.
     */
        public A withNewPodManagementPolicy(java.lang.String arg0);
    public java.lang.Integer getReplicas();
    public A withReplicas(java.lang.Integer replicas);
    public java.lang.Boolean hasReplicas();
    public java.lang.Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(java.lang.Integer revisionHistoryLimit);
    public java.lang.Boolean hasRevisionHistoryLimit();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getSelector();
    public io.fabric8.kubernetes.api.model.LabelSelector buildSelector();
    public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector);
    public java.lang.Boolean hasSelector();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> withNewSelector();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editSelector();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item);
    public java.lang.String getServiceName();
    public A withServiceName(java.lang.String serviceName);
    public java.lang.Boolean hasServiceName();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withServiceName instead.
     */
        public A withNewServiceName(java.lang.String arg0);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.PodTemplateSpec getTemplate();
    public io.fabric8.kubernetes.api.model.PodTemplateSpec buildTemplate();
    public A withTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template);
    public java.lang.Boolean hasTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> withNewTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildUpdateStrategy instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy getUpdateStrategy();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy buildUpdateStrategy();
    public A withUpdateStrategy(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy updateStrategy);
    public java.lang.Boolean hasUpdateStrategy();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy item);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy item);
    public A addToVolumeClaimTemplates(int index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
    public A setToVolumeClaimTemplates(int index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
    public A addToVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
    public A addAllToVolumeClaimTemplates(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items);
    public A removeFromVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
    public A removeAllFromVolumeClaimTemplates(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items);
    public A removeMatchingFromVolumeClaimTemplates(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVolumeClaimTemplates instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> getVolumeClaimTemplates();
    public java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> buildVolumeClaimTemplates();
    public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildVolumeClaimTemplate(int index);
    public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildFirstVolumeClaimTemplate();
    public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildLastVolumeClaimTemplate();
    public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildMatchingVolumeClaimTemplate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> predicate);
    public java.lang.Boolean hasMatchingVolumeClaimTemplate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> predicate);
    public A withVolumeClaimTemplates(java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> volumeClaimTemplates);
    public A withVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... volumeClaimTemplates);
    public java.lang.Boolean hasVolumeClaimTemplates();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(int index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(int index);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> predicate);
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.LabelSelectorFluent<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<N>> {

            public N and();
            public N endSelector();    }


    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.PodTemplateSpecFluent<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


    public interface UpdateStrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyFluent<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<N>> {

            public N and();
            public N endUpdateStrategy();    }


    public interface VolumeClaimTemplatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>> {

            public N and();
            public N endVolumeClaimTemplate();    }


}
