package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class StatefulSetStatusBuilder extends io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluentImpl<io.fabric8.kubernetes.api.model.apps.StatefulSetStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apps.StatefulSetStatus,io.fabric8.kubernetes.api.model.apps.StatefulSetStatusBuilder>{
  public StatefulSetStatusBuilder() {
    this(false);
  }
  public StatefulSetStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new StatefulSetStatus(), validationEnabled);
  }
  public StatefulSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new StatefulSetStatus(), validationEnabled);
  }
  public StatefulSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.StatefulSetStatus instance) {
    this(fluent, instance, false);
  }
  public StatefulSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.StatefulSetStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
    fluent.withCollisionCount(instance.getCollisionCount()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withCurrentReplicas(instance.getCurrentReplicas()); 
    fluent.withCurrentRevision(instance.getCurrentRevision()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withReadyReplicas(instance.getReadyReplicas()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withUpdateRevision(instance.getUpdateRevision()); 
    fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetStatus instance) {
    this(instance,false);
  }
  public StatefulSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withCollisionCount(instance.getCollisionCount()); 
    this.withConditions(instance.getConditions()); 
    this.withCurrentReplicas(instance.getCurrentReplicas()); 
    this.withCurrentRevision(instance.getCurrentRevision()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUpdateRevision(instance.getUpdateRevision()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatus build() {
    StatefulSetStatus buildable = new StatefulSetStatus(fluent.getAvailableReplicas(),fluent.getCollisionCount(),fluent.getConditions(),fluent.getCurrentReplicas(),fluent.getCurrentRevision(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas(),fluent.getUpdateRevision(),fluent.getUpdatedReplicas());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StatefulSetStatusBuilder that = (StatefulSetStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}