package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ReplicaSetBuilder extends io.fabric8.kubernetes.api.model.apps.ReplicaSetFluentImpl<io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apps.ReplicaSet,io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder>{
  public ReplicaSetBuilder() {
    this(false);
  }
  public ReplicaSetBuilder(java.lang.Boolean validationEnabled) {
    this(new ReplicaSet(), validationEnabled);
  }
  public ReplicaSetBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicaSet(), validationEnabled);
  }
  public ReplicaSetBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.ReplicaSet instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.ReplicaSet instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSet instance) {
    this(instance,false);
  }
  public ReplicaSetBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSet instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.ReplicaSet build() {
    ReplicaSet buildable = new ReplicaSet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReplicaSetBuilder that = (ReplicaSetBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}