package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonSetConditionBuilder extends DaemonSetConditionFluentImpl<DaemonSetConditionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.apps.DaemonSetCondition,DaemonSetConditionBuilder>{
  public DaemonSetConditionBuilder() {
    this(false);
  }
  public DaemonSetConditionBuilder(Boolean validationEnabled) {
    this(new DaemonSetCondition(), validationEnabled);
  }
  public DaemonSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DaemonSetCondition(), validationEnabled);
  }
  public DaemonSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DaemonSetCondition instance) {
    this(fluent, instance, false);
  }
  public DaemonSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DaemonSetCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetCondition instance) {
    this(instance,false);
  }
  public DaemonSetConditionBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.DaemonSetConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.DaemonSetCondition build() {
    DaemonSetCondition buildable = new DaemonSetCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}