package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DaemonSetSpecFluentImpl<A extends DaemonSetSpecFluent<A>> extends BaseFluent<A> implements DaemonSetSpecFluent<A>{
  public DaemonSetSpecFluentImpl() {
  }
  public DaemonSetSpecFluentImpl(io.fabric8.kubernetes.api.model.apps.DaemonSetSpec instance) {
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withTemplate(instance.getTemplate()); 
    this.withUpdateStrategy(instance.getUpdateStrategy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer minReadySeconds;
  private java.lang.Integer revisionHistoryLimit;
  private LabelSelectorBuilder selector;
  private PodTemplateSpecBuilder template;
  private DaemonSetUpdateStrategyBuilder updateStrategy;
  private Map<String,Object> additionalProperties;
  public java.lang.Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  public A withMinReadySeconds(java.lang.Integer minReadySeconds) {
    this.minReadySeconds=minReadySeconds; return (A) this;
  }
  public Boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  public java.lang.Integer getRevisionHistoryLimit() {
    return this.revisionHistoryLimit;
  }
  public A withRevisionHistoryLimit(java.lang.Integer revisionHistoryLimit) {
    this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
  }
  public java.lang.Boolean hasRevisionHistoryLimit() {
    return this.revisionHistoryLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  public DaemonSetSpecFluent.SelectorNested<A> withNewSelector() {
    return new DaemonSetSpecFluentImpl.SelectorNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new DaemonSetSpecFluentImpl.SelectorNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.PodTemplateSpec getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public io.fabric8.kubernetes.api.model.PodTemplateSpec buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
  }
  public java.lang.Boolean hasTemplate() {
    return this.template != null;
  }
  public DaemonSetSpecFluent.TemplateNested<A> withNewTemplate() {
    return new DaemonSetSpecFluentImpl.TemplateNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
    return new io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluentImpl.TemplateNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildUpdateStrategy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public DaemonSetUpdateStrategy getUpdateStrategy() {
    return this.updateStrategy!=null ?this.updateStrategy.build():null;
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy buildUpdateStrategy() {
    return this.updateStrategy!=null ?this.updateStrategy.build():null;
  }
  public A withUpdateStrategy(io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy updateStrategy) {
    _visitables.get("updateStrategy").remove(this.updateStrategy);
    if (updateStrategy!=null){ this.updateStrategy= new io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyBuilder(updateStrategy); _visitables.get("updateStrategy").add(this.updateStrategy);} return (A) this;
  }
  public java.lang.Boolean hasUpdateStrategy() {
    return this.updateStrategy != null;
  }
  public DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
    return new DaemonSetSpecFluentImpl.UpdateStrategyNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy item) {
    return new io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluentImpl.UpdateStrategyNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
    return withNewUpdateStrategyLike(getUpdateStrategy());
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
    return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): new io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy item) {
    return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DaemonSetSpecFluentImpl that = (DaemonSetSpecFluentImpl) o;
    if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
    if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (template != null ? !template.equals(that.template) :that.template != null) return false;
    if (updateStrategy != null ? !updateStrategy.equals(that.updateStrategy) :that.updateStrategy != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(minReadySeconds,  revisionHistoryLimit,  selector,  template,  updateStrategy,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (revisionHistoryLimit != null) { sb.append("revisionHistoryLimit:"); sb.append(revisionHistoryLimit + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (updateStrategy != null) { sb.append("updateStrategy:"); sb.append(updateStrategy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<DaemonSetSpecFluent.SelectorNested<N>> implements io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) DaemonSetSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<DaemonSetSpecFluent.TemplateNested<N>> implements io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateNestedImpl(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
      this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder builder;
    public N and() {
      return (N) DaemonSetSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  class UpdateStrategyNestedImpl<N> extends DaemonSetUpdateStrategyFluentImpl<DaemonSetSpecFluent.UpdateStrategyNested<N>> implements io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent.UpdateStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UpdateStrategyNestedImpl(io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy item) {
      this.builder = new DaemonSetUpdateStrategyBuilder(this, item);
    }
    UpdateStrategyNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyBuilder builder;
    public N and() {
      return (N) DaemonSetSpecFluentImpl.this.withUpdateStrategy(builder.build());
    }
    public N endUpdateStrategy() {
      return and();
    }
    
  }
  
}