package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonSetUpdateStrategyBuilder extends DaemonSetUpdateStrategyFluentImpl<DaemonSetUpdateStrategyBuilder> implements VisitableBuilder<DaemonSetUpdateStrategy,io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyBuilder>{
  public DaemonSetUpdateStrategyBuilder() {
    this(false);
  }
  public DaemonSetUpdateStrategyBuilder(Boolean validationEnabled) {
    this(new DaemonSetUpdateStrategy(), validationEnabled);
  }
  public DaemonSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DaemonSetUpdateStrategy(), validationEnabled);
  }
  public DaemonSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy instance) {
    this(fluent, instance, false);
  }
  public DaemonSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRollingUpdate(instance.getRollingUpdate()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy instance) {
    this(instance,false);
  }
  public DaemonSetUpdateStrategyBuilder(io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRollingUpdate(instance.getRollingUpdate()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.DaemonSetUpdateStrategy build() {
    DaemonSetUpdateStrategy buildable = new DaemonSetUpdateStrategy(fluent.getRollingUpdate(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}