package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentBuilder extends DeploymentFluentImpl<DeploymentBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.apps.Deployment,DeploymentBuilder>{
  public DeploymentBuilder() {
    this(false);
  }
  public DeploymentBuilder(Boolean validationEnabled) {
    this(new Deployment(), validationEnabled);
  }
  public DeploymentBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Deployment(), validationEnabled);
  }
  public DeploymentBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.Deployment instance) {
    this(fluent, instance, false);
  }
  public DeploymentBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.Deployment instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentBuilder(io.fabric8.kubernetes.api.model.apps.Deployment instance) {
    this(instance,false);
  }
  public DeploymentBuilder(io.fabric8.kubernetes.api.model.apps.Deployment instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.DeploymentFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.Deployment build() {
    Deployment buildable = new Deployment(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}