package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentSpecBuilder extends DeploymentSpecFluentImpl<DeploymentSpecBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.apps.DeploymentSpec,io.fabric8.kubernetes.api.model.apps.DeploymentSpecBuilder>{
  public DeploymentSpecBuilder() {
    this(false);
  }
  public DeploymentSpecBuilder(Boolean validationEnabled) {
    this(new DeploymentSpec(), validationEnabled);
  }
  public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentSpecBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentSpec(), validationEnabled);
  }
  public DeploymentSpecBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DeploymentSpec instance) {
    this(fluent, instance, false);
  }
  public DeploymentSpecBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.DeploymentSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
    fluent.withPaused(instance.getPaused()); 
    fluent.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withStrategy(instance.getStrategy()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentSpecBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentSpec instance) {
    this(instance,false);
  }
  public DeploymentSpecBuilder(io.fabric8.kubernetes.api.model.apps.DeploymentSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withPaused(instance.getPaused()); 
    this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withStrategy(instance.getStrategy()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.DeploymentSpec build() {
    DeploymentSpec buildable = new DeploymentSpec(fluent.getMinReadySeconds(),fluent.getPaused(),fluent.getProgressDeadlineSeconds(),fluent.getReplicas(),fluent.getRevisionHistoryLimit(),fluent.getSelector(),fluent.getStrategy(),fluent.getTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}