package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaSetBuilder extends ReplicaSetFluentImpl<ReplicaSetBuilder> implements VisitableBuilder<ReplicaSet,io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder>{
  public ReplicaSetBuilder() {
    this(false);
  }
  public ReplicaSetBuilder(Boolean validationEnabled) {
    this(new ReplicaSet(), validationEnabled);
  }
  public ReplicaSetBuilder(ReplicaSetFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicaSet(), validationEnabled);
  }
  public ReplicaSetBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.ReplicaSet instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.ReplicaSet instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSet instance) {
    this(instance,false);
  }
  public ReplicaSetBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSet instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.ReplicaSet build() {
    ReplicaSet buildable = new ReplicaSet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}