package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaSetListBuilder extends ReplicaSetListFluentImpl<ReplicaSetListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.apps.ReplicaSetList,io.fabric8.kubernetes.api.model.apps.ReplicaSetListBuilder>{
  public ReplicaSetListBuilder() {
    this(false);
  }
  public ReplicaSetListBuilder(Boolean validationEnabled) {
    this(new ReplicaSetList(), validationEnabled);
  }
  public ReplicaSetListBuilder(ReplicaSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicaSetList(), validationEnabled);
  }
  public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.ReplicaSetList instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.ReplicaSetList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetList instance) {
    this(instance,false);
  }
  public ReplicaSetListBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.ReplicaSetListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.ReplicaSetList build() {
    ReplicaSetList buildable = new ReplicaSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}