package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatefulSetBuilder extends StatefulSetFluentImpl<StatefulSetBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.apps.StatefulSet,StatefulSetBuilder>{
  public StatefulSetBuilder() {
    this(false);
  }
  public StatefulSetBuilder(Boolean validationEnabled) {
    this(new StatefulSet(), validationEnabled);
  }
  public StatefulSetBuilder(StatefulSetFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new StatefulSet(), validationEnabled);
  }
  public StatefulSetBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.StatefulSet instance) {
    this(fluent, instance, false);
  }
  public StatefulSetBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.StatefulSet instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSet instance) {
    this(instance,false);
  }
  public StatefulSetBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSet instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.StatefulSetFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.StatefulSet build() {
    StatefulSet buildable = new StatefulSet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}