package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatefulSetListBuilder extends StatefulSetListFluentImpl<StatefulSetListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.apps.StatefulSetList,StatefulSetListBuilder>{
  public StatefulSetListBuilder() {
    this(false);
  }
  public StatefulSetListBuilder(Boolean validationEnabled) {
    this(new StatefulSetList(), validationEnabled);
  }
  public StatefulSetListBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetListBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new StatefulSetList(), validationEnabled);
  }
  public StatefulSetListBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.StatefulSetList instance) {
    this(fluent, instance, false);
  }
  public StatefulSetListBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetListFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.StatefulSetList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetListBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetList instance) {
    this(instance,false);
  }
  public StatefulSetListBuilder(io.fabric8.kubernetes.api.model.apps.StatefulSetList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.apps.StatefulSetListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.apps.StatefulSetList build() {
    StatefulSetList buildable = new StatefulSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}