package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

 /**
  * Generated
  */
public interface StatefulSetSpecFluent<A extends StatefulSetSpecFluent<A>> extends Fluent<A>{
  public Integer getMinReadySeconds();
  public A withMinReadySeconds(java.lang.Integer minReadySeconds);
  public Boolean hasMinReadySeconds();
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeClaimRetentionPolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public StatefulSetPersistentVolumeClaimRetentionPolicy getPersistentVolumeClaimRetentionPolicy();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetPersistentVolumeClaimRetentionPolicy buildPersistentVolumeClaimRetentionPolicy();
  public A withPersistentVolumeClaimRetentionPolicy(io.fabric8.kubernetes.api.model.apps.StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy);
  public java.lang.Boolean hasPersistentVolumeClaimRetentionPolicy();
  public A withNewPersistentVolumeClaimRetentionPolicy(String whenDeleted,java.lang.String whenScaled);
  public StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicy();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicyLike(io.fabric8.kubernetes.api.model.apps.StatefulSetPersistentVolumeClaimRetentionPolicy item);
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editPersistentVolumeClaimRetentionPolicy();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicy();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicyLike(io.fabric8.kubernetes.api.model.apps.StatefulSetPersistentVolumeClaimRetentionPolicy item);
  public java.lang.String getPodManagementPolicy();
  public A withPodManagementPolicy(java.lang.String podManagementPolicy);
  public java.lang.Boolean hasPodManagementPolicy();
  public java.lang.Integer getReplicas();
  public A withReplicas(java.lang.Integer replicas);
  public java.lang.Boolean hasReplicas();
  public java.lang.Integer getRevisionHistoryLimit();
  public A withRevisionHistoryLimit(java.lang.Integer revisionHistoryLimit);
  public java.lang.Boolean hasRevisionHistoryLimit();
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LabelSelector getSelector();
  public io.fabric8.kubernetes.api.model.LabelSelector buildSelector();
  public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector);
  public java.lang.Boolean hasSelector();
  public StatefulSetSpecFluent.SelectorNested<A> withNewSelector();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item);
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editSelector();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item);
  public java.lang.String getServiceName();
  public A withServiceName(java.lang.String serviceName);
  public java.lang.Boolean hasServiceName();
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public PodTemplateSpec getTemplate();
  public io.fabric8.kubernetes.api.model.PodTemplateSpec buildTemplate();
  public A withTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template);
  public java.lang.Boolean hasTemplate();
  public StatefulSetSpecFluent.TemplateNested<A> withNewTemplate();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item);
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editTemplate();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item);
  
  /**
   * This method has been deprecated, please use method buildUpdateStrategy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public StatefulSetUpdateStrategy getUpdateStrategy();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy buildUpdateStrategy();
  public A withUpdateStrategy(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy updateStrategy);
  public java.lang.Boolean hasUpdateStrategy();
  public StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy item);
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy item);
  public A addToVolumeClaimTemplates(java.lang.Integer index,PersistentVolumeClaim item);
  public A setToVolumeClaimTemplates(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
  public A addToVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
  public A addAllToVolumeClaimTemplates(Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items);
  public A removeFromVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
  public A removeAllFromVolumeClaimTemplates(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items);
  public A removeMatchingFromVolumeClaimTemplates(Predicate<PersistentVolumeClaimBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildVolumeClaimTemplates instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public List<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> getVolumeClaimTemplates();
  public java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> buildVolumeClaimTemplates();
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildVolumeClaimTemplate(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildFirstVolumeClaimTemplate();
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildLastVolumeClaimTemplate();
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildMatchingVolumeClaimTemplate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> predicate);
  public java.lang.Boolean hasMatchingVolumeClaimTemplate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> predicate);
  public A withVolumeClaimTemplates(java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> volumeClaimTemplates);
  public A withVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... volumeClaimTemplates);
  public java.lang.Boolean hasVolumeClaimTemplates();
  public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item);
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> predicate);
  public A addToAdditionalProperties(java.lang.String key,Object value);
  public A addToAdditionalProperties(Map<java.lang.String,java.lang.Object> map);
  public A removeFromAdditionalProperties(java.lang.String key);
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map);
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties);
  public java.lang.Boolean hasAdditionalProperties();
  public interface PersistentVolumeClaimRetentionPolicyNested<N> extends Nested<N>,StatefulSetPersistentVolumeClaimRetentionPolicyFluent<StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<N>>{
    public N and();
    public N endPersistentVolumeClaimRetentionPolicy();
    
  }
  public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<StatefulSetSpecFluent.SelectorNested<N>>{
    public N and();
    public N endSelector();
    
  }
  public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<StatefulSetSpecFluent.TemplateNested<N>>{
    public N and();
    public N endTemplate();
    
  }
  public interface UpdateStrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StatefulSetUpdateStrategyFluent<StatefulSetSpecFluent.UpdateStrategyNested<N>>{
    public N and();
    public N endUpdateStrategy();
    
  }
  public interface VolumeClaimTemplatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>>{
    public N and();
    public N endVolumeClaimTemplate();
    
  }
  
}