package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface StatefulSetStatusFluent<A extends StatefulSetStatusFluent<A>> extends Fluent<A>{
  public Integer getAvailableReplicas();
  public A withAvailableReplicas(java.lang.Integer availableReplicas);
  public Boolean hasAvailableReplicas();
  public java.lang.Integer getCollisionCount();
  public A withCollisionCount(java.lang.Integer collisionCount);
  public java.lang.Boolean hasCollisionCount();
  public A addToConditions(java.lang.Integer index,StatefulSetCondition item);
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition... items);
  public A addAllToConditions(Collection<io.fabric8.kubernetes.api.model.apps.StatefulSetCondition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition... items);
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.apps.StatefulSetCondition> items);
  public A removeMatchingFromConditions(Predicate<StatefulSetConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.apps.StatefulSetCondition> getConditions();
  public java.util.List<io.fabric8.kubernetes.api.model.apps.StatefulSetCondition> buildConditions();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetCondition buildCondition(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.apps.StatefulSetCondition buildFirstCondition();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetCondition buildLastCondition();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder> predicate);
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder> predicate);
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.apps.StatefulSetCondition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition... conditions);
  public java.lang.Boolean hasConditions();
  public A addNewCondition(String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type);
  public StatefulSetStatusFluent.ConditionsNested<A> addNewCondition();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item);
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.apps.StatefulSetCondition item);
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> editFirstCondition();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> editLastCondition();
  public io.fabric8.kubernetes.api.model.apps.StatefulSetStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.apps.StatefulSetConditionBuilder> predicate);
  public java.lang.Integer getCurrentReplicas();
  public A withCurrentReplicas(java.lang.Integer currentReplicas);
  public java.lang.Boolean hasCurrentReplicas();
  public java.lang.String getCurrentRevision();
  public A withCurrentRevision(java.lang.String currentRevision);
  public java.lang.Boolean hasCurrentRevision();
  public Long getObservedGeneration();
  public A withObservedGeneration(java.lang.Long observedGeneration);
  public java.lang.Boolean hasObservedGeneration();
  public java.lang.Integer getReadyReplicas();
  public A withReadyReplicas(java.lang.Integer readyReplicas);
  public java.lang.Boolean hasReadyReplicas();
  public java.lang.Integer getReplicas();
  public A withReplicas(java.lang.Integer replicas);
  public java.lang.Boolean hasReplicas();
  public java.lang.String getUpdateRevision();
  public A withUpdateRevision(java.lang.String updateRevision);
  public java.lang.Boolean hasUpdateRevision();
  public java.lang.Integer getUpdatedReplicas();
  public A withUpdatedReplicas(java.lang.Integer updatedReplicas);
  public java.lang.Boolean hasUpdatedReplicas();
  public A addToAdditionalProperties(java.lang.String key,Object value);
  public A addToAdditionalProperties(Map<java.lang.String,java.lang.Object> map);
  public A removeFromAdditionalProperties(java.lang.String key);
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map);
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties);
  public java.lang.Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,StatefulSetConditionFluent<StatefulSetStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  
}