package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentStrategyBuilder extends DeploymentStrategyFluentImpl<DeploymentStrategyBuilder> implements VisitableBuilder<DeploymentStrategy,DeploymentStrategyBuilder>{
  public DeploymentStrategyBuilder() {
    this(false);
  }
  public DeploymentStrategyBuilder(Boolean validationEnabled) {
    this(new DeploymentStrategy(), validationEnabled);
  }
  public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentStrategy(), validationEnabled);
  }
  public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent,DeploymentStrategy instance) {
    this(fluent, instance, false);
  }
  public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent,DeploymentStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRollingUpdate(instance.getRollingUpdate()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentStrategyBuilder(DeploymentStrategy instance) {
    this(instance,false);
  }
  public DeploymentStrategyBuilder(DeploymentStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRollingUpdate(instance.getRollingUpdate()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  DeploymentStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentStrategy build() {
    DeploymentStrategy buildable = new DeploymentStrategy(fluent.getRollingUpdate(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}