package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatefulSetConditionBuilder extends StatefulSetConditionFluentImpl<StatefulSetConditionBuilder> implements VisitableBuilder<StatefulSetCondition,StatefulSetConditionBuilder>{
  public StatefulSetConditionBuilder() {
    this(false);
  }
  public StatefulSetConditionBuilder(Boolean validationEnabled) {
    this(new StatefulSetCondition(), validationEnabled);
  }
  public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatefulSetCondition(), validationEnabled);
  }
  public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent,StatefulSetCondition instance) {
    this(fluent, instance, false);
  }
  public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent,StatefulSetCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetConditionBuilder(StatefulSetCondition instance) {
    this(instance,false);
  }
  public StatefulSetConditionBuilder(StatefulSetCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StatefulSetConditionFluent<?> fluent;
  Boolean validationEnabled;
  public StatefulSetCondition build() {
    StatefulSetCondition buildable = new StatefulSetCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}