package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ControllerRevisionListFluent<A extends ControllerRevisionListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,ControllerRevision item);
  public A setToItems(int index,ControllerRevision item);
  public A addToItems(io.fabric8.kubernetes.api.model.apps.ControllerRevision... items);
  public A addAllToItems(Collection<ControllerRevision> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.apps.ControllerRevision... items);
  public A removeAllFromItems(Collection<ControllerRevision> items);
  public A removeMatchingFromItems(Predicate<ControllerRevisionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ControllerRevision> getItems();
  public List<ControllerRevision> buildItems();
  public ControllerRevision buildItem(int index);
  public ControllerRevision buildFirstItem();
  public ControllerRevision buildLastItem();
  public ControllerRevision buildMatchingItem(Predicate<ControllerRevisionBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ControllerRevisionBuilder> predicate);
  public A withItems(List<ControllerRevision> items);
  public A withItems(io.fabric8.kubernetes.api.model.apps.ControllerRevision... items);
  public Boolean hasItems();
  public ControllerRevisionListFluent.ItemsNested<A> addNewItem();
  public ControllerRevisionListFluent.ItemsNested<A> addNewItemLike(ControllerRevision item);
  public ControllerRevisionListFluent.ItemsNested<A> setNewItemLike(int index,ControllerRevision item);
  public ControllerRevisionListFluent.ItemsNested<A> editItem(int index);
  public ControllerRevisionListFluent.ItemsNested<A> editFirstItem();
  public ControllerRevisionListFluent.ItemsNested<A> editLastItem();
  public ControllerRevisionListFluent.ItemsNested<A> editMatchingItem(Predicate<ControllerRevisionBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ControllerRevisionFluent<ControllerRevisionListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}