package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RollingUpdateDeploymentBuilder extends RollingUpdateDeploymentFluentImpl<RollingUpdateDeploymentBuilder> implements VisitableBuilder<RollingUpdateDeployment,RollingUpdateDeploymentBuilder>{
  public RollingUpdateDeploymentBuilder() {
    this(false);
  }
  public RollingUpdateDeploymentBuilder(Boolean validationEnabled) {
    this(new RollingUpdateDeployment(), validationEnabled);
  }
  public RollingUpdateDeploymentBuilder(RollingUpdateDeploymentFluent<?> fluent) {
    this(fluent, false);
  }
  public RollingUpdateDeploymentBuilder(RollingUpdateDeploymentFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RollingUpdateDeployment(), validationEnabled);
  }
  public RollingUpdateDeploymentBuilder(RollingUpdateDeploymentFluent<?> fluent,RollingUpdateDeployment instance) {
    this(fluent, instance, false);
  }
  public RollingUpdateDeploymentBuilder(RollingUpdateDeploymentFluent<?> fluent,RollingUpdateDeployment instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMaxSurge(instance.getMaxSurge());
      fluent.withMaxUnavailable(instance.getMaxUnavailable());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RollingUpdateDeploymentBuilder(RollingUpdateDeployment instance) {
    this(instance,false);
  }
  public RollingUpdateDeploymentBuilder(RollingUpdateDeployment instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMaxSurge(instance.getMaxSurge());
      this.withMaxUnavailable(instance.getMaxUnavailable());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RollingUpdateDeploymentFluent<?> fluent;
  Boolean validationEnabled;
  public RollingUpdateDeployment build() {
    RollingUpdateDeployment buildable = new RollingUpdateDeployment(fluent.getMaxSurge(),fluent.getMaxUnavailable());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}