package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonSetStatusBuilder extends DaemonSetStatusFluent<DaemonSetStatusBuilder> implements VisitableBuilder<DaemonSetStatus,DaemonSetStatusBuilder>{
  public DaemonSetStatusBuilder() {
    this(false);
  }
  public DaemonSetStatusBuilder(Boolean validationEnabled) {
    this(new DaemonSetStatus(), validationEnabled);
  }
  public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DaemonSetStatus(), validationEnabled);
  }
  public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent,DaemonSetStatus instance) {
    this(fluent, instance, false);
  }
  public DaemonSetStatusBuilder(DaemonSetStatusFluent<?> fluent,DaemonSetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DaemonSetStatus());

    if (instance != null) {
      fluent.withCollisionCount(instance.getCollisionCount());
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
      fluent.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
      fluent.withNumberAvailable(instance.getNumberAvailable());
      fluent.withNumberMisscheduled(instance.getNumberMisscheduled());
      fluent.withNumberReady(instance.getNumberReady());
      fluent.withNumberUnavailable(instance.getNumberUnavailable());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled());
      fluent.withCollisionCount(instance.getCollisionCount());
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
      fluent.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
      fluent.withNumberAvailable(instance.getNumberAvailable());
      fluent.withNumberMisscheduled(instance.getNumberMisscheduled());
      fluent.withNumberReady(instance.getNumberReady());
      fluent.withNumberUnavailable(instance.getNumberUnavailable());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetStatusBuilder(DaemonSetStatus instance) {
    this(instance,false);
  }
  public DaemonSetStatusBuilder(DaemonSetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DaemonSetStatus());

    if (instance != null) {
      this.withCollisionCount(instance.getCollisionCount());
      this.withConditions(instance.getConditions());
      this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
      this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
      this.withNumberAvailable(instance.getNumberAvailable());
      this.withNumberMisscheduled(instance.getNumberMisscheduled());
      this.withNumberReady(instance.getNumberReady());
      this.withNumberUnavailable(instance.getNumberUnavailable());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled());
      this.withCollisionCount(instance.getCollisionCount());
      this.withConditions(instance.getConditions());
      this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled());
      this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled());
      this.withNumberAvailable(instance.getNumberAvailable());
      this.withNumberMisscheduled(instance.getNumberMisscheduled());
      this.withNumberReady(instance.getNumberReady());
      this.withNumberUnavailable(instance.getNumberUnavailable());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DaemonSetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public DaemonSetStatus build() {
    DaemonSetStatus buildable = new DaemonSetStatus(fluent.getCollisionCount(),fluent.buildConditions(),fluent.getCurrentNumberScheduled(),fluent.getDesiredNumberScheduled(),fluent.getNumberAvailable(),fluent.getNumberMisscheduled(),fluent.getNumberReady(),fluent.getNumberUnavailable(),fluent.getObservedGeneration(),fluent.getUpdatedNumberScheduled());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}