package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonSetBuilder extends DaemonSetFluent<DaemonSetBuilder> implements VisitableBuilder<DaemonSet,DaemonSetBuilder>{
  public DaemonSetBuilder() {
    this(false);
  }
  public DaemonSetBuilder(Boolean validationEnabled) {
    this(new DaemonSet(), validationEnabled);
  }
  public DaemonSetBuilder(DaemonSetFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetBuilder(DaemonSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DaemonSet(), validationEnabled);
  }
  public DaemonSetBuilder(DaemonSetFluent<?> fluent,DaemonSet instance) {
    this(fluent, instance, false);
  }
  public DaemonSetBuilder(DaemonSetFluent<?> fluent,DaemonSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DaemonSet());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetBuilder(DaemonSet instance) {
    this(instance,false);
  }
  public DaemonSetBuilder(DaemonSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DaemonSet());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DaemonSetFluent<?> fluent;
  Boolean validationEnabled;
  public DaemonSet build() {
    DaemonSet buildable = new DaemonSet(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}