package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonSetUpdateStrategyBuilder extends DaemonSetUpdateStrategyFluent<DaemonSetUpdateStrategyBuilder> implements VisitableBuilder<DaemonSetUpdateStrategy,DaemonSetUpdateStrategyBuilder>{
  public DaemonSetUpdateStrategyBuilder() {
    this(false);
  }
  public DaemonSetUpdateStrategyBuilder(Boolean validationEnabled) {
    this(new DaemonSetUpdateStrategy(), validationEnabled);
  }
  public DaemonSetUpdateStrategyBuilder(DaemonSetUpdateStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetUpdateStrategyBuilder(DaemonSetUpdateStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DaemonSetUpdateStrategy(), validationEnabled);
  }
  public DaemonSetUpdateStrategyBuilder(DaemonSetUpdateStrategyFluent<?> fluent,DaemonSetUpdateStrategy instance) {
    this(fluent, instance, false);
  }
  public DaemonSetUpdateStrategyBuilder(DaemonSetUpdateStrategyFluent<?> fluent,DaemonSetUpdateStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DaemonSetUpdateStrategy());

    if (instance != null) {
      fluent.withRollingUpdate(instance.getRollingUpdate());
      fluent.withType(instance.getType());
      fluent.withRollingUpdate(instance.getRollingUpdate());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetUpdateStrategyBuilder(DaemonSetUpdateStrategy instance) {
    this(instance,false);
  }
  public DaemonSetUpdateStrategyBuilder(DaemonSetUpdateStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DaemonSetUpdateStrategy());

    if (instance != null) {
      this.withRollingUpdate(instance.getRollingUpdate());
      this.withType(instance.getType());
      this.withRollingUpdate(instance.getRollingUpdate());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DaemonSetUpdateStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public DaemonSetUpdateStrategy build() {
    DaemonSetUpdateStrategy buildable = new DaemonSetUpdateStrategy(fluent.buildRollingUpdate(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}