package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ReplicaSetConditionBuilder extends ReplicaSetConditionFluent<ReplicaSetConditionBuilder> implements VisitableBuilder<ReplicaSetCondition,ReplicaSetConditionBuilder>{
  public ReplicaSetConditionBuilder() {
    this(new ReplicaSetCondition());
  }
  
  public ReplicaSetConditionBuilder(ReplicaSetConditionFluent<?> fluent) {
    this(fluent, new ReplicaSetCondition());
  }
  
  public ReplicaSetConditionBuilder(ReplicaSetConditionFluent<?> fluent,ReplicaSetCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ReplicaSetConditionBuilder(ReplicaSetCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ReplicaSetConditionFluent<?> fluent;
  
  public ReplicaSetCondition build() {
    ReplicaSetCondition buildable = new ReplicaSetCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}