
package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "scaleDown",
    "scaleUp"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class HorizontalPodAutoscalerBehavior implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("scaleDown")
    private HPAScalingRules scaleDown;
    /**
     * 
     * 
     */
    @JsonProperty("scaleUp")
    private HPAScalingRules scaleUp;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public HorizontalPodAutoscalerBehavior() {
    }

    /**
     * 
     * @param scaleUp
     * @param scaleDown
     */
    public HorizontalPodAutoscalerBehavior(HPAScalingRules scaleDown, HPAScalingRules scaleUp) {
        this.scaleDown = scaleDown;
        this.scaleUp = scaleUp;
    }

    /**
     * 
     * 
     * @return
     *     The scaleDown
     */
    @JsonProperty("scaleDown")
    public HPAScalingRules getScaleDown() {
        return scaleDown;
    }

    /**
     * 
     * 
     * @param scaleDown
     *     The scaleDown
     */
    @JsonProperty("scaleDown")
    public void setScaleDown(HPAScalingRules scaleDown) {
        this.scaleDown = scaleDown;
    }

    /**
     * 
     * 
     * @return
     *     The scaleUp
     */
    @JsonProperty("scaleUp")
    public HPAScalingRules getScaleUp() {
        return scaleUp;
    }

    /**
     * 
     * 
     * @param scaleUp
     *     The scaleUp
     */
    @JsonProperty("scaleUp")
    public void setScaleUp(HPAScalingRules scaleUp) {
        this.scaleUp = scaleUp;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
