package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MetricValueStatusBuilder extends MetricValueStatusFluentImpl<MetricValueStatusBuilder> implements VisitableBuilder<MetricValueStatus,MetricValueStatusBuilder>{

    MetricValueStatusFluent<?> fluent;
    Boolean validationEnabled;

    public MetricValueStatusBuilder(){
            this(true);
    }
    public MetricValueStatusBuilder(Boolean validationEnabled){
            this(new MetricValueStatus(), validationEnabled);
    }
    public MetricValueStatusBuilder(MetricValueStatusFluent<?> fluent){
            this(fluent, true);
    }
    public MetricValueStatusBuilder(MetricValueStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MetricValueStatus(), validationEnabled);
    }
    public MetricValueStatusBuilder(MetricValueStatusFluent<?> fluent,MetricValueStatus instance){
            this(fluent, instance, true);
    }
    public MetricValueStatusBuilder(MetricValueStatusFluent<?> fluent,MetricValueStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAverageUtilization(instance.getAverageUtilization()); 
            fluent.withAverageValue(instance.getAverageValue()); 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricValueStatusBuilder(MetricValueStatus instance){
            this(instance,true);
    }
    public MetricValueStatusBuilder(MetricValueStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAverageUtilization(instance.getAverageUtilization()); 
            this.withAverageValue(instance.getAverageValue()); 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public MetricValueStatus build(){
            MetricValueStatus buildable = new MetricValueStatus(fluent.getAverageUtilization(),fluent.getAverageValue(),fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricValueStatusBuilder that = (MetricValueStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
