package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HorizontalPodAutoscalerConditionBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder>{

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionFluent<?> fluent;
    Boolean validationEnabled;

    public HorizontalPodAutoscalerConditionBuilder(){
            this(true);
    }
    public HorizontalPodAutoscalerConditionBuilder(Boolean validationEnabled){
            this(new HorizontalPodAutoscalerCondition(), validationEnabled);
    }
    public HorizontalPodAutoscalerConditionBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionFluent<?> fluent){
            this(fluent, true);
    }
    public HorizontalPodAutoscalerConditionBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HorizontalPodAutoscalerCondition(), validationEnabled);
    }
    public HorizontalPodAutoscalerConditionBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition instance){
            this(fluent, instance, true);
    }
    public HorizontalPodAutoscalerConditionBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
            fluent.withMessage(instance.getMessage()); 
            fluent.withReason(instance.getReason()); 
            fluent.withStatus(instance.getStatus()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public HorizontalPodAutoscalerConditionBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition instance){
            this(instance,true);
    }
    public HorizontalPodAutoscalerConditionBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime()); 
            this.withMessage(instance.getMessage()); 
            this.withReason(instance.getReason()); 
            this.withStatus(instance.getStatus()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition build(){
            HorizontalPodAutoscalerCondition buildable = new HorizontalPodAutoscalerCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HorizontalPodAutoscalerConditionBuilder that = (HorizontalPodAutoscalerConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
