package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface ExternalMetricSourceFluent<A extends ExternalMetricSourceFluent<A>> extends Fluent<A>{


    public String getMetricName();
    public A withMetricName(String metricName);
    public Boolean hasMetricName();
    public A withNewMetricName(String arg1);
    public A withNewMetricName(StringBuilder arg1);
    public A withNewMetricName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetricSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getMetricSelector();
    public LabelSelector buildMetricSelector();
    public A withMetricSelector(LabelSelector metricSelector);
    public Boolean hasMetricSelector();
    public ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelector();
    public ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item);
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editMetricSelector();
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelector();
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item);
    public Quantity getTargetAverageValue();
    public A withTargetAverageValue(Quantity targetAverageValue);
    public Boolean hasTargetAverageValue();
    public A withNewTargetAverageValue(String amount,String format);
    public A withNewTargetAverageValue(String amount);
    public Quantity getTargetValue();
    public A withTargetValue(Quantity targetValue);
    public Boolean hasTargetValue();
    public A withNewTargetValue(String amount,String format);
    public A withNewTargetValue(String amount);

    public interface MetricSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<ExternalMetricSourceFluent.MetricSelectorNested<N>>{

        
    public N and();    public N endMetricSelector();
}


}
