package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalMetricSourceBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceBuilder>{

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalMetricSourceBuilder(){
            this(true);
    }
    public ExternalMetricSourceBuilder(Boolean validationEnabled){
            this(new ExternalMetricSource(), validationEnabled);
    }
    public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluent<?> fluent){
            this(fluent, true);
    }
    public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExternalMetricSource(), validationEnabled);
    }
    public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource instance){
            this(fluent, instance, true);
    }
    public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetric(instance.getMetric()); 
            fluent.withTarget(instance.getTarget()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource instance){
            this(instance,true);
    }
    public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetric(instance.getMetric()); 
            this.withTarget(instance.getTarget()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource build(){
            ExternalMetricSource buildable = new ExternalMetricSource(fluent.getMetric(),fluent.getTarget());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExternalMetricSourceBuilder that = (ExternalMetricSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
