package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface PodsMetricSourceFluent<A extends PodsMetricSourceFluent<A>> extends Fluent<A> {


    public String getMetricName();
    public A withMetricName(String metricName);
    public Boolean hasMetricName();
    public A withNewMetricName(String arg1);
    public A withNewMetricName(StringBuilder arg1);
    public A withNewMetricName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public PodsMetricSourceFluent.SelectorNested<A> withNewSelector();
    public PodsMetricSourceFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public PodsMetricSourceFluent.SelectorNested<A> editSelector();
    public PodsMetricSourceFluent.SelectorNested<A> editOrNewSelector();
    public PodsMetricSourceFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    public Quantity getTargetAverageValue();
    public A withTargetAverageValue(Quantity targetAverageValue);
    public Boolean hasTargetAverageValue();
    public A withNewTargetAverageValue(String amount,String format);
    public A withNewTargetAverageValue(String amount);
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PodsMetricSourceFluent.SelectorNested<N>> {

        public N and();
        public N endSelector();    }


}
