package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class HorizontalPodAutoscalerBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscaler,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBuilder>{
  public HorizontalPodAutoscalerBuilder() {
    this(false);
  }
  public HorizontalPodAutoscalerBuilder(java.lang.Boolean validationEnabled) {
    this(new HorizontalPodAutoscaler(), validationEnabled);
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerFluent<?> fluent) {
    this(fluent, false);
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HorizontalPodAutoscaler(), validationEnabled);
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscaler instance) {
    this(fluent, instance, false);
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscaler instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscaler instance) {
    this(instance,false);
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscaler instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscaler build() {
    HorizontalPodAutoscaler buildable = new HorizontalPodAutoscaler(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HorizontalPodAutoscalerBuilder that = (HorizontalPodAutoscalerBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}